<?php

class Odin_audio_widget extends WP_Widget {

  public function __construct() {
    $widget_ops = array('classname' => 'audio_widget', 'description' => __( 'Widget para mostrar os audios recentes.', 'odin'));
    parent::__construct('odin_audio_widget', __( 'Widget Áudio', 'odin'), $widget_ops, $control_ops);
  }

  public function widget( $args, $instance ) {

      extract($args);
          $title = apply_filters( 'widget_title', empty($instance['title']) ? '' : $instance['title'], $instance );
          $quantidade = apply_filters( 'widget_audio', $instance['quantidade'], $instance );
          echo $before_widget;
          if ( !empty( $title ) ) { echo $before_title . $title . $after_title; }

          $args = array('post_type'=>'audio', 'numberposts'=>$quantidade);
          $the_query = new WP_query( $args );
          if( have_posts() ):?>
            <div class="widget-content">
                <?php while ( $the_query->have_posts() ) : $the_query->the_post(); ?>
                  <h5><?php echo the_title(); ?> - em <?php echo get_the_date(); ?></h5>
                  <audio preload="metadata" controls="controls">
                      <source src="<?php echo esc_url( get_post_meta(  get_the_ID(), 'audio_archives', true ) ); ?>" type="audio/mp3" /> seu navegador não suporta HTML5
                  </audio>
                  <hr />
                   <p class="text-right"><a href="<?php echo get_post_type_archive_link( 'audio' ); ?>">Ver todos.</a></p>
                <?php endwhile; ?>
              </div>
          <?php else: ?>
            <p style="text-align: center;">Nenhum áudio cadastrado.</p>
          <?php endif; ?>
          <?php
          echo $after_widget;

  }


  public function update( $new_instance, $old_instance ) {
    $instance = $old_instance;
    $instance['title']    = strip_tags($new_instance['title']);
    $instance['quantidade']    = strip_tags($new_instance['quantidade']);
    return $instance;

  }

  public function form( $instance ) {
    $instance       = wp_parse_args( (array) $instance, array( 'title' => '' ) );
    $title        = strip_tags($instance['title']);
    $quantidade        = strip_tags($instance['quantidade']);
?>
    <p><label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Name:', 'odin'); ?></label>
    <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo esc_attr($title); ?>" /></p>

    <p><label for="<?php echo $this->get_field_id('quantidade'); ?>"><?php _e('Quantidade:', 'odin'); ?></label>
    <input class="widefat" id="<?php echo $this->get_field_id('quantidade'); ?>" name="<?php echo $this->get_field_name('quantidade'); ?>" type="text" value="<?php echo esc_attr($quantidade); ?>" /></p>
<?php
  }
}

add_action('widgets_init', create_function('', 'return register_widget("Odin_audio_widget");'));
