<?php 

/*
Template Name: Licitações
*/
 
// Buscar arquivo header.php
get_header(); ?> 

<div class="title-page">
<div class="container-fluid">
	<div class="row">
		<div class="col-md-12">
			<h1><?php the_title(); ?></h1>		
		</div> 
	</div>
</div>
</div>

<div class="container-fluid">
	
	<div class="row">
		
		<div class="col-md-12 content-table">
		
		 <!--/ start-->
		 <div class="table-responsive">
		 <table class="table table-striped table-bordered">
		  <tr class="success text-uppercase">
		    <td>Processo</td>
		    <td>Objeto</td>
		    <td>Publicação</td>
		    <td>Abertura</td>
		    <td>Modalidade</td>
		    <td>Situação</td>
		    <td class="text-center">Arquivo</td>
		  </tr>
		
			<?php 

			$tax = 'tipos_licitacoes';
			$oterm = 'licitacao'; 
			$term = get_term_by('slug', $oterm, $tax);
			$termChildren = get_term_children($term->term_id, $tax);
			$wp_query = new WP_Query();
			$wp_query->query(
				array(
					'posts_per_page' => '-1',
					'tax_query' => array(
						array(
							'taxonomy' => $tax,
							'field' => 'slug',
							'terms' => $oterm
						), 
						array(
							'taxonomy' => $tax,
							'field' => 'id',
							'terms' => $termChildren,
							'operator' => 'NOT IN'
						)
					)
				)
			);
				
			?>
			<?php while (have_posts()) : the_post(); ?>	 	 
			  <tr>
			    <td><?php the_title(); ?></td>
				<td><?php echo rwmb_meta('textarea_licitacao'); ?></td>
				<td><?php echo rwmb_meta('date_licitacao_publi'); ?></td>
			    <td><?php echo rwmb_meta('date_licitacao_abertura'); ?></td>
			    <td>
				<?php
					$term_list = wp_get_post_terms($post->ID, 'modalidade_licitacao', array("fields" => "names"));
					print_r($term_list[0]);
				?>				
				</td>
			    <td>
				<?php
					$term_list = wp_get_post_terms($post->ID, 'situacao_licitacao', array("fields" => "names"));
					print_r($term_list[0]);
				?>				
				</td>
			    <td>
				<a href="<?php the_permalink(); ?>" class="btn btn-success text-uppercase center-block btn-sm">Ver detalhes</a>				
				</td>  				
			  </tr>
		 	<?php endwhile;?>		  
		</table> 
		</div> 
		<!--/end table-->		

		</div>

	</div>
</div>

<?php 
// buscar arquivo footer.php
get_footer(); ?>