<?php 
// Buscar arquivo header.php
get_header(); ?>

<section class="width-noticias">
	<section class="container">
		<section class="row">
			<section class="col-md-5">
			  <div id="bloco-flip-noticias" class="carousel slide" data-ride="carousel">
		        <!-- Indicators -->
		        <ol class="carousel-indicators">
		          <li data-target="#bloco-flip-noticias" data-slide-to="0" class="active"></li>
		          <li data-target="#bloco-flip-noticias" data-slide-to="1"></li>  
		          <li data-target="#bloco-flip-noticias" data-slide-to="2"></li>  
		        </ol>

		        <!-- Wrapper for slides -->
		        <div class="carousel-inner" role="listbox">
		          		
				<?php $the_query = new WP_Query(array(
					'post_type' =>'post',
					'posts_per_page' => 3, 
					'offset' => 0
					));
					$i = 1;
					while ( $the_query->have_posts() ) : $the_query->the_post(); ?>						
				  <div class="item <?php if($i == 1) echo 'active'; ?>">
					<?php the_post_thumbnail( 'noticia-maior' ); ?>
		            <div class="carousel-caption">
		              <span class="text-uppercase"><?php echo get_the_date(); ?></span>
		              <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
		            </div>
		          </div>
				  <?php $i++; endwhile; wp_reset_postdata(); ?> 
		       
		        </div>
		      </div>				
			</section>
			<section class="col-md-3">
				<ul class="list-unstyled">
					<li><a href="https://camaraabaiara.ce.gov.br/portal-da-transparencia/"><img src="<?php bloginfo('template_url'); ?>/images/btn-portal.png" class="img-responsive"></a></li>
					<li><a href="https://camaraabaiara.ce.gov.br/contas-publicas/"><img src="<?php bloginfo('template_url'); ?>/images/btn-contas.png" class="img-responsive"></a></li>
					<li><a href="https://camaraabaiara.ce.gov.br/esic-acesso/"><img src="<?php bloginfo('template_url'); ?>/images/btn-esic-acesso.png" class="img-responsive"></a></li>
				</ul>
			</section>
			<section class="col-md-2">
				<ul class="list-unstyled">
					<li><a href="https://camaraabaiara.ce.gov.br/ouvidoria/"><img src="<?php bloginfo('template_url'); ?>/images/btn-ouvidoria.png"></a></li>
					<li><a href="https://camaraabaiara.ce.gov.br/contas-publicas/relatorio-de-gestao-fiscal/"><img src="<?php bloginfo('template_url'); ?>/images/btn-lrf.png"></a></li>
					<li><a href="https://camaraabaiara.ce.gov.br/legislacao/lei-organica-municipio/"><img src="<?php bloginfo('template_url'); ?>/images/btn-leis.png"></a></li>
				</ul>
			</section>
			<section class="col-md-2">
				<ul class="list-unstyled">
					<li><a href="https://camaraabaiara.ce.gov.br/legislacao/regimento-interno/"><img src="<?php bloginfo('template_url'); ?>/images/btn-regimento.png"></a></li>
					<li><a href="https://camaraabaiara.ce.gov.br/camara/mesa-diretora/"><img src="<?php bloginfo('template_url'); ?>/images/btn-mesa.png"></a></li>
					<li><a href="https://camaraabaiara.ce.gov.br/vereadores/"><img src="<?php bloginfo('template_url'); ?>/images/btn-vereadores.png"></a></li>
				</ul>				
			</section>
		</section>
	</section>
</section>

<section class="container more-noticias">
	<section class="row">
		
		  <?php 
		  $posts_flip = new WP_Query(array(
			'post_type' => 'post',
			'posts_per_page' => 3,
			'offset' => 3
		  ));
		  while($posts_flip->have_posts()) : $posts_flip->the_post(); ?>		
		<section class="col-md-4">
			<div class="media">
			  <div class="media-left">
			    <a href="<?php the_permalink(); ?>" class="img-responsive">
					<?php the_post_thumbnail( 'noticia-menor' ); ?>
			    </a>
			  </div>
			  <div class="media-body">
			  	<span><?php echo get_the_date(); ?></span>
			    <h4 class="media-heading"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
			    <p></p> 
			  </div>
			</div>			
		</section>
		<?php endwhile; wp_reset_postdata(); ?> 
					
	</section>
</section>

<section class="container info-home">
	<section class="row">
			
		<section class="col-md-4">
			<h4 class="text-uppercase">Tv Câmara</h4>
				<div class="">
				 <?php echo do_shortcode('[embedyt] https://www.youtube.com/watch?v=glHkwKp2Y3o[/embedyt]'); ?> 
					
				</div>	
		</section>
		
		<section class="col-md-4">
			<h4 class="text-uppercase">Campanha</h4>
				<img src="https://camaraabaiara.ce.gov.br/wp-content/uploads/2021/11/dengue.jpg" class="img-responsive" alt="...">
				<h3>Todos contra a Dengue</h3>	
		</section>
		<section class="col-md-4">
			<h4 class="text-uppercase">Covid - 19</h4>
				<a href="https://abaiara.ce.gov.br/covid-19/"><img src="https://camaraabaiara.ce.gov.br/wp-content/uploads/2021/11/covid-19.jpg" class="img-responsive" alt="..."></a>
				<h3>Boletim COVID</h3>	
		</section>				
	</section>
</section>

<section class="container pdfs-home"> 
	<section class="row">
		<section class="col-md-4">
			<h3 class="text-uppercase">Relatório de gestão Fiscal</h3>
			<ul class="list-unstyled">
				
			<?php 

			$tax = 'tipos_contas_publicas';
			$oterm = 'relatorio-de-gestao-fiscal'; 
			$term = get_term_by('slug', $oterm, $tax);
			$termChildren = get_term_children($term->term_id, $tax);
			$wp_query = new WP_Query();
			$wp_query->query(
				array(
					'posts_per_page' => '4',
					'tax_query' => array(
						array(
							'taxonomy' => $tax,
							'field' => 'slug',
							'terms' => $oterm
						),
						array(
							'taxonomy' => $tax,
							'field' => 'id',
							'terms' => $termChildren,
							'operator' => 'NOT IN'
						)
					)
				)
			);
				
			?>
			<?php while (have_posts()) : the_post(); ?>				
				<li class="text-uppercase">
					<span>
					RGF - 
				<?php
					$term_list = wp_get_post_terms($post->ID, 'competencia_contas_publicas', array("fields" => "names"));
					print_r($term_list[0]);
				?> - 
				<?php
					$term_list = wp_get_post_terms($post->ID, 'exercicio_contas_publicas', array("fields" => "names"));
					print_r($term_list[0]);
				?>						
					</span>
					<a href="<?php the_permalink(); ?>"><img src="<?php bloginfo('template_url'); ?>/images/busca-pdf.png" class="pull-right"></a>
				</li>
				<?php endwhile;?>
				<a href="https://camaraabaiara.ce.gov.br/contas-publicas/relatorio-de-gestao-fiscal/" class="btn-more-pdf text-center text-uppercase">ver todas as publicações</a>								
			</ul>
		</section>
		<section class="col-md-4">
			<h3 class="text-uppercase">Projetos de Lei</h3>
			<ul class="list-unstyled">
			
			<?php 
			$tax = 'tipos_proposituras';
			$oterm = 'projetos-de-lei'; 
			$term = get_term_by('slug', $oterm, $tax);
			$termChildren = get_term_children($term->term_id, $tax);
			$wp_query = new WP_Query();
			$wp_query->query(
				array(
					'posts_per_page' => '4',
					'tax_query' => array(
						array(
							'taxonomy' => $tax,
							'field' => 'slug',
							'terms' => $oterm
						), 
						array(
							'taxonomy' => $tax,
							'field' => 'id',
							'terms' => $termChildren,
							'operator' => 'NOT IN'
						)
					)
				)
			);
				
			?>
			<?php while (have_posts()) : the_post(); ?>			
				<li class="text-uppercase">
					<span>
					<?php the_title(); ?> - 
				  <?php echo rwmb_meta('date_proposit'); ?>					
					</span>
					<a href="<?php the_permalink(); ?>"><img src="<?php bloginfo('template_url'); ?>/images/busca-pdf.png" class="pull-right"></a>
				</li>
				<?php endwhile;?>
				<a href="https://camaraabaiara.ce.gov.br/proposituras/projetos-de-lei/" class="btn-more-pdf text-center text-uppercase">ver todas as publicações</a>								
			</ul>
		</section>
		<section class="col-md-4">
			<h3 class="text-uppercase">Requerimentos</h3>
			<ul class="list-unstyled">
				
			<?php 
			$tax = 'tipos_proposituras';
			$oterm = 'requerimentos'; 
			$term = get_term_by('slug', $oterm, $tax);
			$termChildren = get_term_children($term->term_id, $tax);
			$wp_query = new WP_Query();
			$wp_query->query(
				array(
					'posts_per_page' => '4',
					'tax_query' => array(
						array(
							'taxonomy' => $tax,
							'field' => 'slug',
							'terms' => $oterm
						), 
						array(
							'taxonomy' => $tax,
							'field' => 'id',
							'terms' => $termChildren,
							'operator' => 'NOT IN'
						)
					)
				)
			);
				
			?>
			<?php while (have_posts()) : the_post(); ?>					
				<li class="text-uppercase">
					<span>
					<?php the_title(); ?>
				  				
					</span>
					<a href="<?php the_permalink(); ?>"><img src="<?php bloginfo('template_url'); ?>/images/busca-pdf.png" class="pull-right"></a>
				</li>
				<?php endwhile;?>

				<a href="https://camaraabaiara.ce.gov.br/proposituras/requerimentos/" class="btn-more-pdf text-center text-uppercase">ver todas as publicações</a>								
			</ul>
		</section>
		<section class="col-md-4">
			<h3 class="text-uppercase">Atas de Sessão</h3>
			<ul class="list-unstyled">
				
			<?php 

			$tax = 'tipos_leis_fiscais';
			$oterm = 'atas-de-sessao'; 
			$term = get_term_by('slug', $oterm, $tax);
			$termChildren = get_term_children($term->term_id, $tax);
			$wp_query = new WP_Query();
			$wp_query->query(
				array(
					'posts_per_page' => '4',
					'tax_query' => array(
						array(
							'taxonomy' => $tax,
							'field' => 'slug',
							'terms' => $oterm
						),
						array(
							'taxonomy' => $tax,
							'field' => 'id',
							'terms' => $termChildren,
							'operator' => 'NOT IN'
						)
					)
				)
			);
				
			?>
			<?php while (have_posts()) : the_post(); ?>				
				<li class="text-uppercase">
					<span>
					<?php the_title(); ?> - <?php echo rwmb_meta('date_legi'); ?>					
					</span>
					<a href="<?php the_permalink(); ?>"><img src="<?php bloginfo('template_url'); ?>/images/busca-pdf.png" class="pull-right"></a>
				</li>
				<?php endwhile;?>

				<a href="https://camaraabaiara.ce.gov.br/legislacao/atas-de-sessao/" class="btn-more-pdf text-center text-uppercase">ver todas as publicações</a>								
			</ul>
		</section>
		<section class="col-md-4">
			<h3 class="text-uppercase">Resoluções</h3>
			<ul class="list-unstyled">
				
			<?php 

			$tax = 'tipos_leis_fiscais';
			$oterm = 'resolucoes'; 
			$term = get_term_by('slug', $oterm, $tax);
			$termChildren = get_term_children($term->term_id, $tax);
			$wp_query = new WP_Query();
			$wp_query->query(
				array(
					'posts_per_page' => '4',
					'tax_query' => array(
						array(
							'taxonomy' => $tax,
							'field' => 'slug',
							'terms' => $oterm
						),
						array(
							'taxonomy' => $tax,
							'field' => 'id',
							'terms' => $termChildren,
							'operator' => 'NOT IN'
						)
					)
				)
			);
				
			?>
			<?php while (have_posts()) : the_post(); ?>				
				<li class="text-uppercase">
					<span><?php the_title(); ?> - 
				  <?php echo rwmb_meta('date_legi'); ?></span>
					<a href="<?php the_permalink(); ?>"><img src="<?php bloginfo('template_url'); ?>/images/busca-pdf.png" class="pull-right"></a>
				</li>
				<?php endwhile;?>

				<a href="https://camaraabaiara.ce.gov.br/legislacao/resolucoes/" class="btn-more-pdf text-center text-uppercase">ver todas as publicações</a>								
			</ul>
		</section>
		<section class="col-md-4">
			<h3 class="text-uppercase">Portarias</h3>
			<ul class="list-unstyled">

			<?php 

			$tax = 'tipos_leis_fiscais';
			$oterm = 'portarias'; 
			$term = get_term_by('slug', $oterm, $tax);
			$termChildren = get_term_children($term->term_id, $tax);
			$wp_query = new WP_Query();
			$wp_query->query(
				array(
					'posts_per_page' => '4',
					'tax_query' => array(
						array(
							'taxonomy' => $tax,
							'field' => 'slug',
							'terms' => $oterm
						),
						array(
							'taxonomy' => $tax,
							'field' => 'id',
							'terms' => $termChildren,
							'operator' => 'NOT IN'
						)
					)
				)
			);
				
			?>
			<?php while (have_posts()) : the_post(); ?>
				<li class="text-uppercase">
					<span><?php the_title(); ?> - 
				  <?php echo rwmb_meta('date_legi'); ?></span>
					<a href="<?php the_permalink(); ?>"><img src="<?php bloginfo('template_url'); ?>/images/busca-pdf.png" class="pull-right"></a>
				</li>
				<?php endwhile;?>

				<a href="https://camaraabaiara.ce.gov.br/legislacao/portarias/" class="btn-more-pdf text-center text-uppercase">ver todas as publicações</a>								
			</ul>
		</section>		
	</section>
</section>

<?php 
// buscar arquivo footer.php
get_footer(); ?>