<?php

// Register Custom Post Type
function licitacoes_site() {

	$labels = array(
		'name'                  => _x( 'Licitações', 'Post Type General Name', 'text_domain' ),
		'singular_name'         => _x( 'Licitações', 'Post Type Singular Name', 'text_domain' ),
		'menu_name'             => __( 'Licitações', 'text_domain' ),
		'name_admin_bar'        => __( 'Post Type', 'text_domain' ),
		'archives'              => __( 'Item Archives', 'text_domain' ),
		'parent_item_colon'     => __( 'Parent Item:', 'text_domain' ),
		'all_items'             => __( 'Ver todos', 'text_domain' ),
		'add_new_item'          => __( 'Adicionar novo', 'text_domain' ),
		'add_new'               => __( 'Adicionar novo', 'text_domain' ),
		'new_item'              => __( 'Adicionar', 'text_domain' ),
		'edit_item'             => __( 'Editar', 'text_domain' ),
		'update_item'           => __( 'Atualizar', 'text_domain' ),
		'view_item'             => __( 'Ver', 'text_domain' ),
		'search_items'          => __( 'Procurar', 'text_domain' ),
		'not_found'             => __( 'Not found', 'text_domain' ),
		'not_found_in_trash'    => __( 'Not found in Trash', 'text_domain' ),
		'featured_image'        => __( 'Featured Image', 'text_domain' ),
		'set_featured_image'    => __( 'Set featured image', 'text_domain' ),
		'remove_featured_image' => __( 'Remove featured image', 'text_domain' ),
		'use_featured_image'    => __( 'Use as featured image', 'text_domain' ),
		'insert_into_item'      => __( 'Insert into item', 'text_domain' ),
		'uploaded_to_this_item' => __( 'Uploaded to this item', 'text_domain' ),
		'items_list'            => __( 'Items list', 'text_domain' ),
		'items_list_navigation' => __( 'Items list navigation', 'text_domain' ),
		'filter_items_list'     => __( 'Filter items list', 'text_domain' ),
	);
	$args = array(
		'label'                 => __( 'Post Type', 'text_domain' ),
		'description'           => __( 'Post Type Description', 'text_domain' ),
		'labels'                => $labels,
		'supports'              => array( 'title'),
		'hierarchical'          => false,
		'public'                => true,
		'show_ui'               => true,
		'show_in_menu'          => true,
		'menu_position'         => 5,
		'show_in_admin_bar'     => true,
		'show_in_nav_menus'     => true,
		'can_export'            => true,
		'has_archive'           => true,		
		'exclude_from_search'   => false,
		'publicly_queryable'    => true,
		'capability_type'       => 'post',
	);
	register_post_type( 'licitacoes_site', $args );

}
add_action( 'init', 'licitacoes_site', 0 );

// TIPOS
function cwp_register_taxonomy_genero_licitacao(){
     register_taxonomy( 
          'tipos_licitacoes',
          'licitacoes_site',
          array(
               'label' => __('Tipos'),
               'rewrite' => array('slug' => 'tipo-licitacao'),
               'hierarchical' => true
          )
     );
}
add_action('init', 'cwp_register_taxonomy_genero_licitacao');

// Modalidade
function cwp_register_modalidade_licitacao(){
     register_taxonomy( 
          'modalidade_licitacao',
          'licitacoes_site',
          array(
               'label' => __('Modalidade'),
               'rewrite' => array('slug' => 'modalidade-licitacao'),
               'hierarchical' => true
          )
     );
}
add_action('init', 'cwp_register_modalidade_licitacao');


// Situação
function cwp_register_situacao_licitacao(){
     register_taxonomy( 
          'situacao_licitacao',
          'licitacoes_site',
          array(
               'label' => __('Situação'),
               'rewrite' => array('slug' => 'situacao-licitacao'),
               'hierarchical' => true
          )
     );
}
add_action('init', 'cwp_register_situacao_licitacao');

// Competência
function cwp_register_competencia_aditivos(){
     register_taxonomy( 
          'competencia_lic_aditivos',
          'licitacoes_site',
          array(
               'label' => __('Competência'),
               'rewrite' => array('slug' => 'competencia-licitacao'),
               'hierarchical' => true
          )
     );
}
add_action('init', 'cwp_register_competencia_aditivos');

// Exercício
function cwp_register_exercicio_aditivos_contratos(){
     register_taxonomy( 
          'exercicio_lic_contratos',
          'licitacoes_site',
          array(
               'label' => __('Exercício'),
               'rewrite' => array('slug' => 'exercicio-licitacao'),
               'hierarchical' => true
          )
     );
}
add_action('init', 'cwp_register_exercicio_aditivos_contratos');

?>