<?php

    add_filter( 'rwmb_meta_boxes', 'your_prefix_meta_boxes' );
    function your_prefix_meta_boxes( $meta_boxes ) {
             
		// 	BANNER
        $meta_boxes[] = array(
            'title'      => __( 'Informações adicionais', 'textdomain' ),
            'post_types' => 'slide',
            'fields'     => array(
            
            array(
                'id'   => 'linkbanner',
                'name' => __( 'Link do Banner', 'textdomain' ),
                'type' => 'text',
            ),	
			
            ),
        );	
		
		// 	VEREADORES
        $meta_boxes[] = array(
            'title'      => __( 'Informações adicionais', 'textdomain' ),
            'post_types' => 'vereadores_site',
            'fields'     => array(
            
            array(
                'id'   => 'partido_ver',
                'name' => __( 'Partido', 'textdomain' ),
                'type' => 'text',
            ),	
			
            array(
                'id'   => 'voto_ver',
                'name' => __( 'Votação', 'textdomain' ),
                'type' => 'text',
            ),	

            array(
                'id'   => 'mandato_ver',
                'name' => __( 'Mandato', 'textdomain' ),
                'type' => 'text',
            ),	

            array(
                'id'   => 'telefone_ver',
                'name' => __( 'Telefone', 'textdomain' ),
                'type' => 'text',
            ),				
			
            ),
        );			

		// 	CONTAS PÚBLICAS
        $meta_boxes[] = array(
            'title'      => __( 'Informações adicionais', 'textdomain' ),
            'post_types' => 'post',
            'fields'     => array(

			// FILE ADVANCED (WP 3.5+)
			array(
				'name'             => esc_html__( 'Arquivos', 'your-prefix' ),
				'id'               => "file_advanced_post",
				'type'             => 'file_advanced',
				'max_file_uploads' => 20,
				'mime_type'        => 'application,audio,video', // Leave blank for all file types
			),			
			
            ),
        );
		
        $meta_boxes[] = array(
            'title'      => __( 'Leis Municipais', 'textdomain' ),
            'post_types' => 'leis_municipais_site',
            'fields'     => array(
                array(
                    'id'   => 'numero',
                    'name' => __( 'Número', 'textdomain' ),
					'desc' => __( 'Outras publicações', 'your-prefix' ),
                    'type' => 'text',
                ),
			// TEXTAREA
			array(
				'name' => __( 'Descrição', 'your-prefix' ),
				'desc' => __( 'Outras Publicações', 'your-prefix' ),
				'id'   => "descricao",
				'type' => 'textarea',
				'cols' => 20,
				'rows' => 3,
			),				
			// DATE
			array(
				'name'       => __( 'Data', 'your-prefix' ),
				'id'         => "data",
				'type'       => 'date',
				// jQuery date picker options. See here http://api.jqueryui.com/datepicker
				'js_options' => array(
					'appendText'      => __( '(yyyy-mm-dd)', 'your-prefix' ),
					'dateFormat'      => __( 'dd-mm-yy', 'your-prefix' ),
					'changeMonth'     => true,
					'changeYear'      => true,
					'showButtonPanel' => true,
				),
			),			
                array(
                    'id'   => 'exercicio',
                    'name' => __( 'Exercício', 'textdomain' ),
                    'type' => 'text',
                ), 			

            // FILE ADVANCED (WP 3.5+)
            array(
                'name'             => __( 'Arquivo PDF', 'your-prefix' ),
                'id'               => "file_advanced",
                'type'             => 'file_advanced',
                'max_file_uploads' => 4,
                'mime_type'        => 'application,audio,video', // Leave blank for all file types
            ),
                
            ),

        );			
		
		// 	CONTAS PÚBLICAS
        $meta_boxes[] = array(
            'title'      => __( 'Informações adicionais', 'textdomain' ),
            'post_types' => 'contas_pdf',
            'fields'     => array(
            
			// DATE PUBLICACAO
			array(
				'name'       => esc_html__( 'Data', 'your-prefix' ),
				'id'         => "date_contas_publicas",
				'type'       => 'date',
				// jQuery date picker options. See here http://api.jqueryui.com/datepicker
				'js_options' => array(
					'appendText'      => esc_html__( '(dia-mês-ano)', 'your-prefix' ),
					'dateFormat'      => esc_html__( 'dd-mm-yy', 'your-prefix' ),
					'changeMonth'     => true,
					'changeYear'      => true,
					'showButtonPanel' => true,
				),
			),	

			// FILE ADVANCED (WP 3.5+)
			array(
				'name'             => esc_html__( 'Arquivos', 'your-prefix' ),
				'id'               => "file_advanced_contas",
				'type'             => 'file_advanced',
				'max_file_uploads' => 20,
				'mime_type'        => 'application,audio,video', // Leave blank for all file types
			),			
			
            ),
        );			

		// 	LICITAÇÕES
        $meta_boxes[] = array(
            'title'      => __( 'Informações adicionais', 'textdomain' ),
            'post_types' => 'licitacoes_site',
            'fields'     => array(
            
			// TEXTAREA
			array(
				'name' => esc_html__( 'Objeto', 'your-prefix' ),
				'id'   => "textarea_licitacao",
				'type' => 'textarea',
				'cols' => 90,
				'rows' => 5,
			),				
			
			// DATE PUBLICACAO
			array(
				'name'       => esc_html__( 'Publicação', 'your-prefix' ),
				'id'         => "date_licitacao_publi",
				'type'       => 'date',
				// jQuery date picker options. See here http://api.jqueryui.com/datepicker
				'js_options' => array(
					'appendText'      => esc_html__( '(dia-mês-ano)', 'your-prefix' ),
					'dateFormat'      => esc_html__( 'dd-mm-yy', 'your-prefix' ),
					'changeMonth'     => true,
					'changeYear'      => true,
					'showButtonPanel' => true,
				),
			),	

			// DATE ABERTURA
			array(
				'name'       => esc_html__( 'Abertura', 'your-prefix' ),
				'id'         => "date_licitacao_abertura",
				'type'       => 'date',
				// jQuery date picker options. See here http://api.jqueryui.com/datepicker
				'js_options' => array(
					'appendText'      => esc_html__( '(dia-mês-ano)', 'your-prefix' ),
					'dateFormat'      => esc_html__( 'dd-mm-yy', 'your-prefix' ),
					'changeMonth'     => true,
					'changeYear'      => true,
					'showButtonPanel' => true,
				),
			),				
			
            ),
        );	
		
		// 	LICITAÇÕES BOX ADITIVOS
        $meta_boxes[] = array(
            'title'      => __( 'Informações adivitos e contratos', 'textdomain' ),
            'post_types' => 'licitacoes_site',
            'fields'     => array(

            array(
                'id'   => 'numero_aditivos_contratos',
                'name' => __( 'Número', 'textdomain' ),
                'type' => 'text',
            ),			

			// TEXTAREA
			array(
				'name' => esc_html__( 'Descrição', 'your-prefix' ),
				'id'   => "textarea_lic_contratos",
				'type' => 'textarea',
				'cols' => 90,
				'rows' => 5,
			),	
			
			// DATE PUBLICACAO
			array(
				'name'       => esc_html__( 'Data', 'your-prefix' ),
				'id'         => "date_aditivos_contratos",
				'type'       => 'date',
				// jQuery date picker options. See here http://api.jqueryui.com/datepicker
				'js_options' => array(
					'appendText'      => esc_html__( '(dia-mês-ano)', 'your-prefix' ),
					'dateFormat'      => esc_html__( 'dd-mm-yy', 'your-prefix' ),
					'changeMonth'     => true,
					'changeYear'      => true,
					'showButtonPanel' => true,
				),
			),	

			// FILE ADVANCED (WP 3.5+)
			array(
				'name'             => esc_html__( 'Arquivos', 'your-prefix' ),
				'id'               => "file_advanced_licitacao_contratos",
				'type'             => 'file_advanced',
				'max_file_uploads' => 20,
				'mime_type'        => 'application,audio,video', // Leave blank for all file types
			),			
			
            ),
        );			
		
		// 	Legislação
        $meta_boxes[] = array(
            'title'      => __( 'Informações adicionais', 'textdomain' ),
            'post_types' => 'legislacao_site',
            'fields'     => array(
            
            array(
                'id'   => 'numero_legislacao',
                'name' => __( 'Número', 'textdomain' ),
                'type' => 'text',
            ),			
			
			// DATE
			array(
				'name'       => esc_html__( 'Data', 'your-prefix' ),
				'id'         => "date_legi",
				'type'       => 'date',
				// jQuery date picker options. See here http://api.jqueryui.com/datepicker
				'js_options' => array(
					'appendText'      => esc_html__( '(dia-mês-ano)', 'your-prefix' ),
					'dateFormat'      => esc_html__( 'dd-mm-yy', 'your-prefix' ),
					'changeMonth'     => true,
					'changeYear'      => true,
					'showButtonPanel' => true,
				),
			),			
			
			// TEXTAREA
			array(
				'name' => esc_html__( 'Descrição', 'your-prefix' ),
				'id'   => "textarea_legi",
				'type' => 'textarea',
				'cols' => 20,
				'rows' => 3,
			),	

			// TEXTAREA
			array(
				'name' => esc_html__( 'Informações Adicionais', 'your-prefix' ),
				'id'   => "info_adc_legi",
				'type' => 'textarea',
				'cols' => 20,
				'rows' => 3,
			),				
			
			// FILE ADVANCED (WP 3.5+)
			array(
				'name'             => esc_html__( 'Arquivos', 'your-prefix' ),
				'id'               => "file_advanced_legi",
				'type'             => 'file_advanced',
				'max_file_uploads' => 10,
				'mime_type'        => 'application,audio,video', // Leave blank for all file types
			),		
			
            ),
        );	

		// 	PROPOSITURAS
        $meta_boxes[] = array(
            'title'      => __( 'Informações adicionais', 'textdomain' ),
            'post_types' => 'proposituras_site',
            'fields'     => array(
            
            array(
                'id'   => 'numero_proposituras',
                'name' => __( 'Número', 'textdomain' ),
                'type' => 'text',
            ),				
			
			// DATE
			array(
				'name'       => esc_html__( 'Data', 'your-prefix' ),
				'id'         => "date_proposit",
				'type'       => 'date',
				// jQuery date picker options. See here http://api.jqueryui.com/datepicker
				'js_options' => array(
					'appendText'      => esc_html__( '(dia-mês-ano)', 'your-prefix' ),
					'dateFormat'      => esc_html__( 'dd-mm-yy', 'your-prefix' ),
					'changeMonth'     => true,
					'changeYear'      => true,
					'showButtonPanel' => true,
				),
			),			
			
			// TEXTAREA
			array(
				'name' => esc_html__( 'Descrição', 'your-prefix' ),
				'id'   => "textarea_proposit",
				'type' => 'textarea',
				'cols' => 20,
				'rows' => 3,
			),		

			// TEXTAREA
			array(
				'name' => esc_html__( 'Informações Adicionais', 'your-prefix' ),
				'id'   => "info_adc_proposit",
				'type' => 'textarea',
				'cols' => 20,
				'rows' => 3,
			),				
			
			// FILE ADVANCED (WP 3.5+)
			array(
				'name'             => esc_html__( 'Arquivos', 'your-prefix' ),
				'id'               => "file_advanced_proposit",
				'type'             => 'file_advanced',
				'max_file_uploads' => 10,
				'mime_type'        => 'application,audio,video', // Leave blank for all file types
			),		
			
            ),
        );

		// 	SUB-DOCUMENTOS
        $meta_boxes[] = array(
            'title'      => __( 'Informações adicionais', 'textdomain' ),
            'post_types' => 'sub_documentos_pdf',
            'fields'     => array(
            
			// DATE
			array(
				'name'       => esc_html__( 'Data', 'your-prefix' ),
				'id'         => "date_sub_documentos",
				'type'       => 'date',
				// jQuery date picker options. See here http://api.jqueryui.com/datepicker
				'js_options' => array(
					'appendText'      => esc_html__( '(dia-mês-ano)', 'your-prefix' ),
					'dateFormat'      => esc_html__( 'dd-mm-yy', 'your-prefix' ),
					'changeMonth'     => true,
					'changeYear'      => true,
					'showButtonPanel' => true,
				),
			),			
			
			// TEXTAREA
			array(
				'name' => esc_html__( 'Descrição', 'your-prefix' ),
				'id'   => "textarea_sub_documentos",
				'type' => 'textarea',
				'cols' => 20,
				'rows' => 3,
			),				
			
			// FILE ADVANCED (WP 3.5+)
			array(
				'name'             => esc_html__( 'Arquivos', 'your-prefix' ),
				'id'               => "file_advanced_sub_documentos",
				'type'             => 'file_advanced',
				'max_file_uploads' => 10,
				'mime_type'        => 'application,audio,video', // Leave blank for all file types
			),		
			
            ),
        );			
		
        return $meta_boxes;
    }

?>