<?php
/**
 * The main template file.
 *
 * This is the most generic template file in a WordPress theme and one of the
 * two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * For example, it puts together the home page when no home.php file exists.
 *
 * @link http://codex.wordpress.org/Template_Hierarchy
 *
 * @package Odin
 * @since 2.2.0
 */

get_header();

get_sidebar('left'); ?>
	<main id="content" class="col-sm-12 conteudo" tabindex="-1" role="main">
			<?php require_once get_template_directory() . '/custom/custom-slide.php'; ?>
			<h4 class="">Notícias da <?php echo bloginfo('name'); ?></h4>
			<hr />
			<?php
				if ( have_posts() ) :
					// Start the Loop.
					echo '<div class="row">';
						$the_query = new WP_Query( array( 'posts_per_page' => 3 ) );
						while ( $the_query->have_posts() ) : $the_query->the_post();
							get_template_part( 'content-home', get_post_format() );
						endwhile;
	          				wp_reset_postdata();
          				echo '</div>';

          				echo '<div class="row">';
						$the_query = new WP_Query( array( 'posts_per_page' => 3, 'offset'=>3 ) );
						while ( $the_query->have_posts() ) : $the_query->the_post();
							get_template_part( 'content-home', get_post_format() );
						endwhile;
	        				wp_reset_postdata();
          				echo '</div>';
				else :
					get_template_part( 'content', 'none' );
				endif;
			?>

	</main><!-- #content -->

<?php
get_sidebar('right');
get_footer();
