<?php
/**
 * Search & Filter Pro 
 *
 * Sample Results Template
 * 
 * @package   Search_Filter
 * @author    Ross Morsali
 * @link      https://searchandfilter.com
 * @copyright 2018 Search & Filter
 * 
 * Note: these templates are not full page templates, rather 
 * just an encaspulation of the your results loop which should
 * be inserted in to other pages by using a shortcode - think 
 * of it as a template part
 * 
 * This template is an absolute base example showing you what
 * you can do, for more customisation see the WordPress docs 
 * and using template tags - 
 * 
 * http://codex.wordpress.org/Template_Tags
 *
 */

// If this file is called directly, abort.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( $query->have_posts() )
{
	?>
	
	 <?php echo $query->found_posts; ?> Publicações encontradas<br />
	<table class="table table-striped">
		  <tr class="success text-uppercase">
		    <td>Número</td>
		    <td>Autoria</td>
		    <td>Descrição</td>
		    <td>Competência</td>
		    <td>Exercício</td> 
		    <td>Data</td>  
		    <td class="text-center">Arquivo</td>
		  </tr>	
	
	<?php
	while ($query->have_posts())
	{
		$query->the_post();
		
		?>
		<!---->
		
		<div style="background:#900;">

			  <tr>
			    <td>Nº <?php the_title(); ?></td>
				<td>
				<?php $terms = get_the_terms( $post->ID , 'autoria_proposituras' );
						foreach ( $terms as $term ) {
						echo $term->name;}				
				?>				
				</td>
				<td><?php echo rwmb_meta('textarea_proposit'); ?></td>
			    <td>
				<?php $terms = get_the_terms( $post->ID , 'competencia_proposituras' );
						foreach ( $terms as $term ) {
						echo $term->name;}				
				?>				
				</td>
			    <td>	
				<?php $terms = get_the_terms( $post->ID , 'exerc_proposituras' );
						foreach ( $terms as $term ) {
						echo $term->name;}				
				?>				
				</td>				
				 <td><?php echo rwmb_meta('date_proposit'); ?></td>			    
			    <td>
				<a href="#myModal-<?php the_ID(); ?>" data-toggle="modal" class="btn btn-info center-block btn-sm">Visualizar</a>
				<?php include( get_template_directory() . '/includes/modal-proposituras.php'); ?>					
			    </td>
			  </tr>
			
		</div>
		
		<!---->
		<?php
	}
	?>
	</table>
	
	<div class="pagination">
		
		<div class="nav-previous hidden"><?php next_posts_link( 'Older posts', $query->max_num_pages ); ?></div>
		<div class="nav-next hidden"><?php previous_posts_link( 'Newer posts' ); ?></div>
		<?php
			/* example code for using the wp_pagenavi plugin */
			if (function_exists('wp_pagenavi'))
			{
				echo "<br />";
				wp_pagenavi( array( 'query' => $query ) );
			}
		?>
	</div>
	<?php
}
else
{
	echo "nada encontrado";
}
?>