<?php
/**
 * Search & Filter Pro 
 *
 * Sample Results Template
 * 
 * @package   Search_Filter
 * @author    Ross Morsali
 * @link      http://www.designsandcode.com/
 * @copyright 2015 Designs & Code
 * 
 * Note: these templates are not full page templates, rather 
 * just an encaspulation of the your results loop which should
 * be inserted in to other pages by using a shortcode - think 
 * of it as a template part
 * 
 * This template is an absolute base example showing you what
 * you can do, for more customisation see the WordPress docs 
 * and using template tags - 
 * 
 * http://codex.wordpress.org/Template_Tags
 *
 */

global $searchandfilter;
$sf_current_query = $searchandfilter->get(22306)->current_query();
if ((!$sf_current_query->is_filtered())&&($sf_current_query->get_search_term()=="")) {
  echo '<div></div>'; 
} else {
	
	if ( $query->have_posts() )
{
	?>
	<hr style="height:1px;background:#ccc;">
	<b><?php echo $query->found_posts; ?></b> Resultados encontrados<br />
	Páginas <?php echo $query->query['paged']; ?> de <?php echo $query->max_num_pages; ?><br /><br />
	
<ul class="list-group">
	
	<?php
	while ($query->have_posts())
	{
		$query->the_post();
		
		?>
		<li class="list-group-item text-left" onclick="location.href='<?php the_permalink(); ?>';">
		<span class="badge">
			<?php 
				$obj = get_post_type_object(get_post_type($post->ID));
				echo '' .  $obj->labels->name . '';
			?>		
		</span>
			<h5><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h5>	
		</li>
		
		<?php
	}
	?>
	</ul>
	Página <?php echo $query->query['paged']; ?> de <?php echo $query->max_num_pages; ?><br />
	
	<div class="pagination">
		<?php
			/* example code for using the wp_pagenavi plugin */
			if (function_exists('wp_pagenavi'))
			{
				echo "<br />";
				wp_pagenavi( array( 'query' => $query ) );
			}
		?>
	</div>
	<?php
}
else
{
	echo "No Results Found";
}
}
?>