<?php 

/*
Template Name: Vereadores
*/
 
// Buscar arquivo header.php
get_header(); ?> 

<div class="title-page">
<div class="container-fluid">
	<div class="row">
		<div class="col-md-12">
			<h1><?php the_title(); ?></h1>		
		</div>
	</div>
</div>
</div>

<div class="container-fluid">
	<div class="row"> 
	<div class="col-md-10">
	<div class="row">
			<?php 

			$tax = 'anos_vereadores';
			$oterm = '2021-2024'; 
			$term = get_term_by('slug', $oterm, $tax);
			$termChildren = get_term_children($term->term_id, $tax);
			$wp_query = new WP_Query();
			$wp_query->query(
				array(
					'posts_per_page' => '-1',
					'tax_query' => array(
						array(
							'taxonomy' => $tax,
							'field' => 'slug',
							'terms' => $oterm
						), 
						array(
							'taxonomy' => $tax,
							'field' => 'id',
							'terms' => $termChildren,
							'operator' => 'NOT IN'
						)
					)
				)
			);
				
			?>
			<?php while (have_posts()) : the_post(); ?>		
		<div class="col-xs-6 col-md-2 ver-page"> 
			<?php the_post_thumbnail('medium', array('class' => 'img-responsive')); ?>
			<h4><?php the_title(); ?></h4>
			<ul class="list-unstyled">
				<li class="text-uppercase"><?php echo rwmb_meta('funcao_ver'); ?></li>
			</ul>
		</div>
		<?php endwhile;?>
	</div>	
	</div>
	<div class="col-md-2">
		<p class="text-uppercase">Vereadores por período</p>
		<a href="http://camarajati.ce.gov.br/vereadores-2017-2020/" class="btn btn-info center-block text-uppercase">2017-2020</a>
	</div>
	</div>	
</div>

<?php 
// buscar arquivo footer.php
get_footer(); ?>