<?php

// MENU
require_once('includes/wp_bootstrap_navwalker.php');
register_nav_menus( array(
    'primary' => __( 'Menu Principal', 'prefAbaira' ),
) );
//
register_nav_menus( array(
    'acesso-rapido' => __( 'Rodape Acesso Rapido', 'prefAbaira' ),
) );
//
register_nav_menus( array(
    'links-uteis' => __( 'Rodape Links Úteis', 'prefAbaira' ),
) );
//
register_nav_menus( array(
    'links-sidebar' => __( 'Sidebar Links', 'prefAbaira' ),
) );

// Class nas img post/page
function img_responsive($content){
    return str_replace('<img class="','<img class="img-responsive ',$content);
}
add_filter('the_content','img_responsive');

// habilitar imgs thumb
add_theme_support( 'post-thumbnails' );

// Buscar custon post type slide
require get_template_directory() . '/includes/slider.php';

// Buscar metabox
require get_template_directory() . '/includes/demo.php';

// Buscar legislação
require get_template_directory() . '/includes/tipo-arquivo-legislacao.php';

// Buscar roposituras
require get_template_directory() . '/includes/tipo-arquivo-proposituras.php';

// Buscar sub-documentos
require get_template_directory() . '/includes/tipo-arquivo-sub-documentos.php';

// Buscar licitações 
require get_template_directory() . '/includes/post-type-licitacoes.php';

// Buscar transparencia
require get_template_directory() . '/includes/post-type-transparencia.php';

// Buscar vereadores
require get_template_directory() . '/includes/tipo-arquivo-vereadores.php';

// Buscar tv
require get_template_directory() . '/includes/cpt-tv.php';

// Buscar portaria
require get_template_directory() . '/includes/cpt-portaria.php';

// Galeria de imagens
function pexeto_add_title_to_attachment( $markup, $id ){
	$att = get_post( $id );
	return str_replace('<a ', '<a title="'.$att->post_title.'" ', $markup);
}
add_filter('wp_get_attachment_link', 'pexeto_add_title_to_attachment', 10, 5);

// MINIATURA WHATSAPP
function doctype_opengraph($output) {
    return $output . '
    xmlns:og="http://opengraphprotocol.org/schema/"
    xmlns:fb="http://www.facebook.com/2008/fbml"';
}
add_filter('language_attributes', 'doctype_opengraph');
function fb_opengraph() {
    global $post;

    if(is_single()) {
        if(has_post_thumbnail($post->ID)) {
            $img_src = wp_get_attachment_image_src(get_post_thumbnail_id( $post->ID ), 'thumbnail');
        } else {
            $img_src = get_stylesheet_directory_uri() . '/img/opengraph_image.jpg';
        }
        if($excerpt = $post->post_excerpt) {
            $excerpt = strip_tags($post->post_excerpt);
            $excerpt = str_replace("", "'", $excerpt);
        } else {
            $excerpt = get_bloginfo('description');
        }
        ?>

    <meta property="og:title" content="<?php echo the_title(); ?>"/>
    <meta property="og:description" content="<?php echo $excerpt; ?>"/>
    <meta property="og:type" content="article"/>
    <meta property="og:url" content="<?php echo the_permalink(); ?>"/>
    <meta property="og:site_name" content="<?php echo get_bloginfo(); ?>"/>
    <meta property="og:image" content="<?php echo $img_src[0]; ?>"/>

<?php
    } else {
        return;
    }
}
add_action('wp_head', 'fb_opengraph', 5);

?>