<?php 

/*
Template Name: PCG – Prestação de Contas de Governo
*/

// Buscar arquivo header.php
get_header(); ?> 


<div class="container trilha">
	<div class="row">
		<div class="col-md-12">
			<span><?php if ( function_exists('yoast_breadcrumb') ) 
			{yoast_breadcrumb('<p class="pull-right" id="breadcrumbs">','</p>');} ?></span>			
		</div>
	</div>
</div>

<div class="container">
	
	<div class="row">
		<div class="col-md-12 title-page"><h1><?php the_title();?></h1></div>
	</div>

	<?php
	// buscar search-modelo-internas.php
	include( get_template_directory() . '/inc/search-modelo-internas.php'); ?>	
	
	<div class="row">
		
		<div class="col-md-12 content-table">
		
		 <!--/ start-->
		 <div class="table-responsive">
		 <table class="table table-striped table-bordered">
		  <tr class="success">
		    <td>Descrição</td>
		    <td>Competência</td>
		    <td>Data</td>
		    <td>Exercício</td>
		    <td>Arquivo</td>
		  </tr>
		
			<?php 

			$tax = 'genero_contas';
			$oterm = 'pcg-prestacao-de-contas-de-governo'; 
			$term = get_term_by('slug', $oterm, $tax);
			$termChildren = get_term_children($term->term_id, $tax);
			$wp_query = new WP_Query();
			$wp_query->query(
				array(
					'posts_per_page' => '-1',
					'tax_query' => array(
						array(
							'taxonomy' => $tax,
							'field' => 'slug',
							'terms' => $oterm
						),
						array(
							'taxonomy' => $tax,
							'field' => 'id',
							'terms' => $termChildren,
							'operator' => 'NOT IN'
						)
					)
				)
			);
				
			?>
			<?php while (have_posts()) : the_post(); ?>		 
			  <tr>
			    <td><?php the_title(); ?></td>
			    <td><?php echo rwmb_meta('competencia'); ?></td>
			    <td><?php echo rwmb_meta('data'); ?></td>
			    <td><?php echo rwmb_meta('exercicio'); ?></td>
			    <td>
				
				<div class="btn-downs btn btn-primary btn-xs">
					<span class="glyphicon glyphicon-search"></span>
					<a href="#myModal-<?php the_ID(); ?>" data-toggle="modal" id="clickme">Visualizar</a>
			    </div>	
					<div class="btn-downs btn btn-success btn-xs">
			    		<span class="glyphicon glyphicon-file"></span>
			    		<?php
					    $files = rwmb_meta( 'file_advanced' );              // Since 4.8.0
					    $files = rwmb_meta( 'file_advanced', 'type=file' ); // Prior to 4.8.0
					    if ( !empty( $files ) ) {
					        foreach ( $files as $file ) {
					            echo "<a target='_blank' href='{$file['url']}' title='{$file['title']}'>PDF</a><br />";
					        }
					    }
			    		?>	 
			    	</div>
				<?php
				// buscar slide.php
				include( get_template_directory() . '/inc/modal-content.php'); ?>				
			    </td>
			  </tr>
		 	<?php endwhile;?>		  
		</table> 
		</div> 
		<!--/end table-->			
		
		</div>

	</div>
</div>

<?php 
// buscar arquivo footer.php
get_footer(); ?>