<?php

// MENU
require_once('includes/wp_bootstrap_navwalker.php');
register_nav_menus( array(
    'primary' => __( 'Menu Principal', 'prefAbaira' ),
) );
//
register_nav_menus( array(
    'acesso-rapido' => __( 'Rodape Acesso Rapido', 'prefAbaira' ),
) );
//
register_nav_menus( array(
    'links-uteis' => __( 'Rodape Links Úteis', 'prefAbaira' ),
) );
//
register_nav_menus( array(
    'links-eleicao' => __( 'Menu Eleição', 'prefAbaira' ),
) );
//
register_nav_menus( array(
    'links-sidebar' => __( 'Sidebar Links', 'prefAbaira' ),
) );

// Class nas img post/page
function img_responsive($content){
    return str_replace('<img class="','<img class="img-responsive ',$content);
}
add_filter('the_content','img_responsive');

// habilitar imgs thumb
add_theme_support( 'post-thumbnails' );

// Buscar custon post type slide
require get_template_directory() . '/includes/slider.php';

// Buscar metabox
require get_template_directory() . '/includes/demo.php';

// Buscar legislação
require get_template_directory() . '/includes/tipo-arquivo-legislacao.php';

// Buscar roposituras
require get_template_directory() . '/includes/tipo-arquivo-proposituras.php';

// Buscar sub-documentos
require get_template_directory() . '/includes/tipo-arquivo-sub-documentos.php';

// Buscar licitações 
require get_template_directory() . '/includes/post-type-licitacoes.php';

// Buscar transparencia
require get_template_directory() . '/includes/post-type-transparencia.php';

// Buscar vereadores
require get_template_directory() . '/includes/tipo-arquivo-vereadores.php';

// Galeria de imagens
function pexeto_add_title_to_attachment( $markup, $id ){
	$att = get_post( $id );
	return str_replace('<a ', '<a title="'.$att->post_title.'" ', $markup);
}
add_filter('wp_get_attachment_link', 'pexeto_add_title_to_attachment', 10, 5);

// REMOVER VERSAO WP
function remove_extra_informations()
{
    remove_action( 'wp_head', 'feed_links_extra', 3); // Remover a categoria feeds
    remove_action( 'wp_head', 'feed_links', 2); // Remover Feeds de Post e Comentários 
    remove_action( 'wp_head', 'rsd_link' );
    remove_action( 'wp_head', 'wlwmanifest_link' );
    remove_action( 'wp_head', 'wp_generator' ); // Remove versão do Wordpress
 
    //--  Esta parte é conectada ao gerador de FEED --//
    remove_action( 'rss2_head', 'the_generator' );
    remove_action( 'rss_head',  'the_generator' );
    remove_action( 'rdf_header', 'the_generator' );
    remove_action( 'atom_head', 'the_generator' );
    remove_action( 'commentsrss2_head', 'the_generator' );
    remove_action( 'opml_head', 'the_generator' );
    remove_action( 'app_head',  'the_generator' );
    remove_action( 'comments_atom_head', 'the_generator' );
}
 
add_action( 'after_setup_theme', 'remove_extra_informations' );

?>