<?php
/**
* Theme Options
*/
function odin_theme_option(){

    $settings = new Odin_Theme_Options(
        'theme-option', // Slug/ID da página (Obrigatório)
        __( 'Configurações do tema', 'odin' ), // Titulo da página (Obrigatório)
        'manage_options' // Nível de permissão (Opcional) [padrão é manage_options]
    );

    $settings->set_tabs(
        array(
            array(
                'id' => 'odin_general', // ID da aba e nome da entrada no banco de dados.
                'title' => __( 'Geral', 'odin' ), // Título da aba.
            ),
            array(
                'id' => 'odin_footer', // ID da aba e nome da entrada no banco de dados.
                'title' => __( 'Footer', 'odin' ), // Título da aba.
            )
        )
    );

    $settings->set_fields(
    array(
         'general_section' => array(
            'tab'   => 'odin_general', // Sessão da aba odin_general
            'title' => __( 'Opções principais do tema.', 'odin' ),
            'fields' => array(
                  array(
                        'id'          => 'general_header_imagem', // Obrigatório
                        'label'       => __( 'Header imagem.', 'odin' ), // Obrigatório
                        'type'        => 'upload', // Obrigatório
                        'default'     => '', // Opcional (deve ser o id de uma imagem em mídia)
                        'description' => __( 'Faça o upload de sua imagem para o header.', 'odin' ), // Opcional
                    ),
                  array(
                        'id'          => 'general_color_links', // Obrigatório
                        'label'       => __( 'Cor para os links do site.', 'odin' ), // Obrigatório
                        'type'        => 'color', // Obrigatório
                        'default'     => '#15AB17', // Opcional (cor em hexadecimal)
                        'description' => __( 'Selecione a cor os links do site. Padrão: #15AB17', 'odin' ), // Opcional
                    ),
                  array(
                        'id'          => 'general_color_links_hover', // Obrigatório
                        'label'       => __( 'Cor para os links quando passado o mouse(hover).', 'odin' ), // Obrigatório
                        'type'        => 'color', // Obrigatório
                        'default'     => '#15AB17', // Opcional (cor em hexadecimal)
                        'description' => __( 'Selecione a cor os links do site. Padrão: #15AB17', 'odin' ), // Opcional
                    ),
                    array(
                        'id'          => 'menu_color_primary', // Obrigatório
                        'label'       => __( 'Cor primária do menu.', 'odin' ), // Obrigatório
                        'type'        => 'color', // Obrigatório
                        'default'     => '#287329', // Opcional (cor em hexadecimal)
                        'description' => __( 'Selecione a cor primária para o menu. Padrão: #287329', 'odin' ), // Opcional
                    ),
                    array(
                        'id'          => 'menu_color_secondary', // Obrigatório
                        'label'       => __( 'Cor secundária do menu.', 'odin' ), // Obrigatório
                        'type'        => 'color', // Obrigatório
                        'default'     => '#15AB17', // Opcional (cor em hexadecimal)
                        'description' => __( 'Selecione a cor secundária para o menu. Padrão: #15AB17', 'odin' ), // Opcional
                    ),
                    array(
                        'id'          => 'widget_color_bg', // Obrigatório
                        'label'       => __( 'Cor de fundo do widget.', 'odin' ), // Obrigatório
                        'type'        => 'color', // Obrigatório
                        'default'     => '#287329', // Opcional (cor em hexadecimal)
                        'description' => __( 'Selecione a cor para o fundo do widget. Padrão: #287329', 'odin' ), // Opcional
                    ),
                    array(
                        'id'          => 'widget_color_link', // Obrigatório
                        'label'       => __( 'Cor do link do widget.', 'odin' ), // Obrigatório
                        'type'        => 'color', // Obrigatório
                        'default'     => '#15AB17', // Opcional (cor em hexadecimal)
                        'description' => __( 'Selecione a cor para os links do widget. Padrão: #15AB17', 'odin' ), // Opcional
                    ),
                    array(
                        'id'          => 'widget_color_link_hover', // Obrigatório
                        'label'       => __( 'Cor do link do widget quando passado o mouse(hover).', 'odin' ), // Obrigatório
                        'type'        => 'color', // Obrigatório
                        'default'     => '#15AB17', // Opcional (cor em hexadecimal)
                        'description' => __( 'Selecione a cor para os links do widget. Padrão: #15AB17', 'odin' ), // Opcional
                    )
            )
        ),
        'footer_section' => array(
            'tab'   =>  'odin_footer',
            'title' =>  'Configurações do rodapé',
            'fields'    =>  array(
                array(
                    'id' => 'footer_link_author',
                    'label' => __('Link do site', 'odin'),
                    'type' => 'text',
                    'default' => 'http://',
                    'description' => __('Link de acesso ao seu site.', 'odin')
                ),
                array(
                    'tab' => 'odin_footer',
                    'id' => 'footer_image_author',
                    'label' => __('imagem', 'odin'),
                    'type' => 'upload',
                    'default' => '',
                    'description' => __('Faça o upload de sua imagem.', 'odin')
                )
            )
        ),
      )
    );

}

add_action( 'init', 'odin_theme_option', 1 );