<?php
/**
 * The template for displaying Archive pages.
 *
 * Used to display archive-type pages if nothing more specific matches a query.
 * For example, puts together date-based pages if no date.php file exists.
 *
 * If you'd like to further customize these archive views, you may create a
 * new template file for each specific one. For example, Twenty Thirteen
 * already has tag.php for Tag archives, category.php for Category archives,
 * and author.php for Author archives.
 *
 * @link http://codex.wordpress.org/Template_Hierarchy
 *
 * @package Odin
 * @since 2.2.0
 */

get_header();
get_sidebar('left');?>
  <main id="content" class="<?php echo odin_classes_page_sidebars(); ?>" tabindex="-1" role="main">
        <h3 class="text-left">Tv Câmara</h3>
        <hr />
      <?php if ( have_posts() ) : ?>
      <?php
            $args = array('post_type'=>'video', 'numberposts'=>-1);
            $my_videos = get_posts( $args );
           ?>

        <?php while(have_posts() ) : the_post(); ?>
             <article id="post-<?php the_ID(); ?>" <?php post_class('hentry-video'); ?>>
              <header class="entry-header">
                <?php
                    the_title( '<h3 class="entry-title">', '</h3>' );
                ?>
        <?php
                  $url_youtube = "//www.youtube.com/embed/";
                  $url_vimeo = "//player.vimeo.com/video/";
                  $url_video = "";

                  $textDescription = get_post_meta( $post->ID,'link_youtube_vimeo', true );
                  $parsed     = parse_url($textDescription);
                  $hostname   = $parsed['host'];
                  $query      = $parsed['query'];
                  $path       = $parsed['path'];
                  $Arr = explode('v=',$query);
                  $videoIDwithString = $Arr[1];
                  $videoID = substr($videoIDwithString,0,11); // 5sRDHnTApSw
                      if( (isset($videoID)) && (isset($hostname)) && ($hostname=='www.youtube.com' || $hostname=='youtube.com')){

                          $url_video = $url_youtube .  $videoID;
                      }
                      else  if((isset($hostname)) && $hostname=='vimeo.com'){
                          $ArrV = explode('://vimeo.com/',$path);
                          $videoID = substr($ArrV[0],1,9);
                          $vimdeoIDInt = intval($videoID);

                          $url_video = $url_vimeo . $vimdeoIDInt;
                      }
                  ?>

                <!-- 4:3 aspect ratio -->
                <div class="embed-responsive embed-responsive-4by3">
                  <iframe class="embed-responsive-item" src="<?php echo $url_video; ?>" frameborder="0" webkitAllowFullScreen mozallowfullscreen allowfullscreen></iframe>
                </div>

            </article><!-- #post-## -->
      <?php

         endwhile;

          // Page navigation.
          odin_paging_nav();

        else :
          // If no content, include the "No posts found" template.
          get_template_part( 'content', 'none' );

        endif;
      ?>

  </main><!-- #main -->

<?php
get_sidebar('right');
get_footer();