<?php
/**
 * The template for displaying Archive pages.
 *
 * Used to display archive-type pages if nothing more specific matches a query.
 * For example, puts together date-based pages if no date.php file exists.
 *
 * If you'd like to further customize these archive views, you may create a
 * new template file for each specific one. For example, Twenty Thirteen
 * already has tag.php for Tag archives, category.php for Category archives,
 * and author.php for Author archives.
 *
 * @link http://codex.wordpress.org/Template_Hierarchy
 *
 * @package Odin
 * @since 2.2.0
 */

get_header();
get_sidebar('left');?>
  <main id="content" class="<?php echo odin_classes_page_sidebars(); ?>" tabindex="-1" role="main">
        <h3 class="text-left">Vereadores</h3>
        <hr />
      <?php if ( have_posts() ) : ?>
        <?php
          // Start the Loop.
          while ( have_posts() ) : the_post();

            /*
             * Include the post format-specific template for the content. If you want to
             * use this in a child theme, then include a file called called content-___.php
             * (where ___ is the post format) and that will be used instead.
             */
            ?>
            <article id="post-<?php the_ID(); ?>" <?php post_class('hentry-vereador'); ?>>
              <header class="entry-header">
                <?php
                  if ( is_single() ) :
                    the_title( '<h1 class="entry-title">', '</h1>' );
                  else :
                    the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
                  endif;
                ?>

                <?php if ( 'post' == get_post_type() ) : ?>
                  <div class="entry-meta">
                    <?php odin_posted_on(); ?>
                  </div><!-- .entry-meta -->
                <?php endif; ?>
              </header><!-- .entry-header -->

              <?php if ( is_search() ) : ?>
                <div class="entry-summary">
                  <?php the_excerpt(); ?>
                </div><!-- .entry-summary -->
              <?php else : ?>
                <div class="entry-content">
                  <?php
                    the_content( __( 'Continue reading <span class="meta-nav">&rarr;</span>', 'odin' ) );
                    wp_link_pages( array(
                      'before'      => '<div class="page-links"><span class="page-links-title">' . __( 'Pages:', 'odin' ) . '</span>',
                      'after'       => '</div>',
                      'link_before' => '<span>',
                      'link_after'  => '</span>',
                    ) );
                  ?>
                </div><!-- .entry-content -->
              <?php endif; ?>

              <footer class="entry-meta">
                <?php if ( in_array( 'category', get_object_taxonomies( get_post_type() ) ) ) : ?>
                  <span class="cat-links"><?php echo __( 'Posted in:', 'odin' ) . ' ' . get_the_category_list( _x( ', ', 'Used between list items, there is a space after the comma.', 'odin' ) ); ?></span>
                <?php endif; ?>
                <?php the_tags( '<span class="tag-links">' . __( 'Tagged as:', 'odin' ) . ' ', ', ', '</span>' ); ?>
                <?php if ( ! post_password_required() && ( comments_open() || get_comments_number() ) ) : ?>
                  <span class="comments-link"><?php comments_popup_link( __( 'Leave a comment', 'odin' ), __( '1 Comment', 'odin' ), __( '% Comments', 'odin' ) ); ?></span>
                <?php endif; ?>
              </footer>
            </article><!-- #post-## -->
      <?php

          endwhile;

          // Page navigation.
          odin_paging_nav();

        else :
          // If no content, include the "No posts found" template.
          get_template_part( 'content', 'none' );

        endif;
      ?>

  </main><!-- #main -->

<?php
get_sidebar('right');
get_footer();