<?php
/**
 * The template for displaying Archive pages.
 *
 * Used to display archive-type pages if nothing more specific matches a query.
 * For example, puts together date-based pages if no date.php file exists.
 *
 * If you'd like to further customize these archive views, you may create a
 * new template file for each specific one. For example, Twenty Thirteen
 * already has tag.php for Tag archives, category.php for Category archives,
 * and author.php for Author archives.
 *
 * @link http://codex.wordpress.org/Template_Hierarchy
 *
 * @package Odin
 * @since 2.2.0
 */

get_header(); ?>
  <main id="content" class="<?php echo odin_classes_page_sidebar(); ?>" tabindex="-1" role="main">

      <?php if ( have_posts() ) : ?>
        <header class="page-header">
          <h3 class="page-title">Requerimentos</h3>
        </header><!-- .page-header -->

         <table class="table table-responsive">
            <thead>
              <tr>
                <th>Titulo</th>
                <th>Data de publicação</th>
              </tr>
             </thead>
              <tbody>
        <?php
          // Start the Loop.
          while ( have_posts() ) : the_post();

            /*
             * Include the post format-specific template for the content. If you want to
             * use this in a child theme, then include a file called called content-___.php
             * (where ___ is the post format) and that will be used instead.
             */
            ?>
            <tr>
              <td><?php the_title( '<h5 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h5>' ); ?></td>
              <td><h5 class="entry-title"><?php echo get_the_date(); ?></h5></td>
            </tr>
      <?php
          endwhile; ?>
            </tbody>
          </table>
      <?php

          // Page navigation.
          odin_paging_nav();

        else :
          // If no content, include the "No posts found" template.
          get_template_part( 'content', 'none' );

        endif;
      ?>

  </main><!-- #main -->

<?php
get_sidebar('right');
get_footer();