<?php

class Odin_video_widget extends WP_Widget {

  public function __construct() {
    $widget_ops = array('classname' => 'video_widget', 'description' => __( 'Widgets custom videos.', 'odin'));
    parent::__construct('odin_video_widget', __( 'Custom video widget', 'odin'), $widget_ops, $control_ops);
  }

  public function widget( $args, $instance ) {

      extract($args);
          $title = apply_filters( 'widget_title', empty($instance['title']) ? '' : $instance['title'], $instance );
          echo $before_widget;
          if ( !empty( $title ) ) { echo $before_title . $title . $after_title; }?>

          <?php
            $args = array('post_type'=>'video', 'numberposts'=>1);
            $my_videos = get_posts( $args );
            if( $my_videos ):
           ?>
        <?php foreach ( $my_videos as $post ) : setup_postdata( $post ); ?>
            <?php
                $url_youtube = "//www.youtube.com/embed/";
                $url_vimeo = "//player.vimeo.com/video/";
                $url_video = "";

                $textDescription = get_post_meta( $post->ID,'link_youtube_vimeo', true );
                $parsed     = parse_url($textDescription);
                $hostname   = $parsed['host'];
                $query      = $parsed['query'];
                $path       = $parsed['path'];
                $Arr = explode('v=',$query);
                $videoIDwithString = $Arr[1];
                $videoID = substr($videoIDwithString,0,11); // 5sRDHnTApSw
                    if( (isset($videoID)) && (isset($hostname)) && ($hostname=='www.youtube.com' || $hostname=='youtube.com')){

                        $url_video = $url_youtube .  $videoID;
                    }
                    else  if((isset($hostname)) && $hostname=='vimeo.com'){
                        $ArrV = explode('://vimeo.com/',$path);
                        $videoID = substr($ArrV[0],1,9);
                        $vimdeoIDInt = intval($videoID);

                        $url_video = $url_vimeo . $vimdeoIDInt;
                    }
                ?>

              <div class="embed-responsive embed-responsive-4by3">
                <iframe class="embed-responsive-item" src="<?php echo $url_video; ?>" frameborder="0" webkitAllowFullScreen mozallowfullscreen allowfullscreen></iframe>
              </div>

          <?php endforeach; ?>
          <?php else: ?>
            <p style="text-align: center;">Nenhum vídeo inserido.</p>
          <?php endif; ?>

          <?php
          echo $after_widget;

  }


  public function update( $new_instance, $old_instance ) {
    $instance = $old_instance;
    $instance['title']    = strip_tags($new_instance['title']);
    return $instance;

  }

  public function form( $instance ) {
    $instance       = wp_parse_args( (array) $instance, array( 'title' => '' ) );
    $title        = strip_tags($instance['title']);
    $category        = strip_tags($instance['category']);
?>
    <p><label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Name:', 'odin'); ?></label>
    <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo esc_attr($title); ?>" /></p>
<?php
  }
}

add_action('widgets_init', create_function('', 'return register_widget("Odin_video_widget");'));
