<?php
/* VEREADORES */
function odin_vereadores_cpt() {
    $vereadores = new Odin_Post_Type(
      'Vereador', // Nome (Singular) do Post Type.
      'vereador' // Slug do Post Type.
  );
  $args = array(
      'hierarchical'        => false,
      'supports'            => array( 'title', 'editor'),
      'public'              => true,
      'show_ui'             => true,
      'show_in_menu'        => true,
      'show_in_nav_menus'   => false,
      'publicly_queryable'  => true,
      'exclude_from_search' => true,
      'has_archive'         => true,
      'query_var'           => true,
      'can_export'          => true,
      'rewrite'             => true,
      'capability_type'     => 'post'
  );
  $vereadores->set_labels(
      array(
          'menu_name' => __( 'Vereadores', 'odin' )
      )
  );
  $vereadores->set_arguments(
    array(
        'supports' => array( 'title', 'editor'),
        'menu_icon' => 'dashicons-businessman'
    )
);
}

add_action( 'init', 'odin_vereadores_cpt', 1 );

/* REQUERIMENTOS */
function odin_requerimentos_cpt() {
    $requerimentos = new Odin_Post_Type(
      'Requerimento', // Nome (Singular) do Post Type.
      'requerimento' // Slug do Post Type.
  );
  $args = array(
      'hierarchical'        => false,
      'supports'            => array( 'title', 'editor'),
      'public'              => true,
      'show_ui'             => true,
      'show_in_menu'        => true,
      'show_in_nav_menus'   => false,
      'publicly_queryable'  => true,
      'exclude_from_search' => true,
      'has_archive'         => true,
      'query_var'           => true,
      'can_export'          => true,
      'rewrite'             => true,
      'capability_type'     => 'post'
  );
  $requerimentos->set_labels(
      array(
          'menu_name' => __( 'Requerimentos', 'odin' )
      )
  );
  $requerimentos->set_arguments(
    array(
        'supports' => array( 'title', 'editor'),
        'menu_icon' => 'dashicons-format-aside'
    )
);
}

add_action( 'init', 'odin_requerimentos_cpt', 1 );

//CUSTOM VIDEOS
function odin_videos_cpt() {
    $videos = new Odin_Post_Type(
      'Video', // Nome (Singular) do Post Type.
      'video' // Slug do Post Type.
  );
  $args = array(
      'hierarchical'        => false,
      'supports'            => array( 'title'),
      'public'              => true,
      'show_ui'             => true,
      'show_in_menu'        => true,
      'show_in_nav_menus'   => false,
      'publicly_queryable'  => true,
      'exclude_from_search' => true,
      'has_archive'         => true,
      'query_var'           => true,
      'can_export'          => true,
      'rewrite'             => array('slug'=>'videos'),
      'capability_type'     => 'post'
  );
  $videos->set_labels(
      array(
          'menu_name' => __( 'Tv Câmara', 'odin' )
      )
  );
  $videos->set_arguments(
    array(
        'supports' => array( 'title'),
        'menu_icon' => 'dashicons-format-video'
    )
);
}

add_action( 'init', 'odin_videos_cpt', 1 );

//CUSTOM BALANÇO
function odin_balanco_cpt() {
    $balanco = new Odin_Post_Type(
      'Balanço', // Nome (Singular) do Post Type.
      'balanco' // Slug do Post Type.
  );
  $args = array(
      'hierarchical'        => false,
      'supports'            => array( 'title'),
      'public'              => true,
      'show_ui'             => true,
      'show_in_menu'        => true,
      'show_in_nav_menus'   => false,
      'publicly_queryable'  => true,
      'exclude_from_search' => true,
      'has_archive'         => true,
      'query_var'           => true,
      'can_export'          => true,
      'rewrite'             => array('slug'=>'balanco'),
      'capability_type'     => 'post'
  );
  $balanco->set_labels(
      array(
          'menu_name' => __( 'Balanço', 'odin' )
      )
  );
  $balanco->set_arguments(
    array(
        'supports' => array( 'title'),
        'menu_icon' => 'dashicons-media-text'
    )
);
}

add_action( 'init', 'odin_balanco_cpt', 1 );


//CUSTOM AUDIO
function odin_audio_cpt() {
    $audio = new Odin_Post_Type(
      'Áudio', // Nome (Singular) do Post Type.
      'audio' // Slug do Post Type.
  );
  $args = array(
      'hierarchical'        => false,
      'supports'            => array( 'title'),
      'public'              => true,
      'show_ui'             => true,
      'show_in_menu'        => true,
      'show_in_nav_menus'   => false,
      'publicly_queryable'  => true,
      'exclude_from_search' => true,
      'has_archive'         => true,
      'query_var'           => true,
      'can_export'          => true,
      'rewrite'             => array('slug'=>'audio'),
      'capability_type'     => 'post'
  );
  $audio->set_labels(
      array(
          'menu_name' => __( 'Áudio', 'odin' )
      )
  );
  $audio->set_arguments(
    array(
        'supports' => array( 'title'),
        'menu_icon' => 'dashicons-format-audio'
    )
);
}

add_action( 'init', 'odin_audio_cpt', 1 );