<?php
/*-----------------------------------------------------------------------------------*/
/* Este código chama os arquivos que exigem a instalação dos plugins necessários para o tema.
/*-----------------------------------------------------------------------------------*/
require_once( get_template_directory() . '/tgm/class-tgm-plugin-activation.php' );
require_once( get_template_directory() . '/tgm/plugins-list.php' );

// Atera o excerpt
add_filter('excerpt_length', 'custom_excerpt_length');
function custom_excerpt_length($length) {
  return 120; //Nova quantidade de caracteres do excerpt
}

/*Pagination*/
add_action ('pre_get_posts','set_posts_per_page');
function set_posts_per_page( $query ) {
  if( !is_admin() && $query->is_main_query() ){
      if ( is_tax('requerimentos')  ) {
        $query->set( 'posts_per_page', 20 );
        $query->set( 'post_type', 'requerimento');
    }
    if ( get_query_var('post_type') == 'requerimento' ) {
       $query->set( 'posts_per_page', 20 );
    }
    if ( is_tax('vereadores')  ) {
        $query->set( 'posts_per_page', 5 );
        $query->set( 'post_type', 'vereador');
    }
    if ( get_query_var('post_type') == 'vereador' ) {
       $query->set( 'posts_per_page', 5 );
    }
    if ( is_tax('videos')  ) {
        $query->set( 'posts_per_page', 5 );
        $query->set( 'post_type', 'video');
    }
    if ( get_query_var('post_type') == 'video' ) {
       $query->set( 'posts_per_page', 5 );
    }
    return $query;
}
}

function custom_color_theme(){
  $custom_general_opts = get_option( 'odin_general' );

  /* Links */
  $general_color_links = esc_html( $custom_general_opts['general_color_links'] );
  $general_color_links_hover = esc_html( $custom_general_opts['general_color_links_hover'] );
  /* Menu */
  $color_primary = esc_html( $custom_general_opts['menu_color_primary'] );
  $color_secondary = esc_html( $custom_general_opts['menu_color_secondary'] );
  /* Header */
  $header_image_bg = esc_html( $custom_general_opts['general_header_imagem'] );
  /* Widget */
  $widget_color = esc_html( $custom_general_opts['widget_color_link'] );
  $widget_color_hover = esc_html( $custom_general_opts['widget_color_link_hover'] );
  $widget_bg_color = esc_html( $custom_general_opts['widget_color_bg'] );
  /* Pagination */

?>
<style type="text/css">
    /* links */
    a{
      color: <?php echo $general_color_links; ?>;
    }
    a:hover, a:focus{
      color: <?php echo $general_color_links_hover; ?>;
    }
    /*Header*/
    .page-heading {
        background: #287329 url('<?php echo $header_image_bg; ?>');
    }

    /* Navbar */
    .navbar-default{
      background-color: <?php echo $color_primary;  ?> !important;
    }
    .navbar-default .navbar-nav > .active > a, .navbar-default .navbar-nav > .active > a:hover, .navbar-default .navbar-nav > .active > a:focus{
      background-color: <?php echo $color_secondary;  ?> !important;
    }
    .dropdown-menu>li>a:hover, .dropdown-menu>li>a:focus{
      background-color: <?php echo $color_secondary;  ?> !important;
    }
    .navbar-default .navbar-nav>.open>a, .navbar-default .navbar-nav>.open>a:hover, .navbar-default .navbar-nav>.open>a:focus{
      background-color: <?php echo $color_secondary;  ?> !important;
    }
    .navbar-default .navbar-nav > .active > a,
    .navbar-default .navbar-nav > .active > a:hover,
    .navbar-default .navbar-nav > .active > a:focus {
      background-color: <?php echo $color_secondary;  ?> !important;
    }
    .nav li:hover, .nav li:focus {
      background-color: <?php echo $color_secondary;  ?> !important;
    }

    /* Widget */
    .widget a{
      color: <?php echo $widget_color; ?>;
    }
    .widget a:hover, .widget a:focus{
      color: <?php echo $widget_color_hover; ?>;
    }
    .widgettitle{
      background-color: <?php echo $widget_bg_color; ?>;
    }
    /* Pagination */
    ul.page-numbers>li>span.current, ul.page-numbers>li>span.current:hover, ul.page-numbers>li>span.current:focus{
      background-color: <?php echo $general_color_links; ?>;
      border-color: <?php echo $general_color_links; ?>;
    }
    .pagination>li>a, ul.page-numbers>li>a, .pagination>li>span, ul.page-numbers>li>span,
    .pagination>li>a:hover, ul.page-numbers>li>a:hover,
    .pagination>li>a:focus, ul.page-numbers>li>a:focus{
      color: <?php echo $general_color_links; ?>;
    }
  </style>
<?php
}