<?php

class Odin_category_widget extends WP_Widget {

  public function __construct() {
    $widget_ops = array('classname' => 'category_widget', 'description' => __( 'Widgets custom categories.', 'odin'));
    parent::__construct('odin_category_widget', __( 'Custom category widget', 'odin'), $widget_ops, $control_ops);
  }

  public function widget( $args, $instance ) {

      extract($args);
          $title = apply_filters( 'widget_title', empty($instance['title']) ? '' : $instance['title'], $instance );
          $category = apply_filters( 'widget_category', $instance['category'], $instance );
          echo $before_widget;
          if ( !empty( $title ) ) { echo $before_title . $title . $after_title; }

          $args = array( 'post_type' => ''.$category.'', 'posts_per_page' => 5 , 'no_found_rows' => true, 'post_status' => 'publish' /* 'offset' => 3*/ );
          $the_query = new WP_Query( $args );?>
                <ul>
                <?php if ($the_query->have_posts()) : while ( $the_query->have_posts() ) : $the_query->the_post(); ?>
                        <li><?php echo the_title('<a href="'.esc_url( get_permalink() ).'">', '</a>'); ?></li>
                <?php endwhile; endif; wp_reset_postdata(); ?>
                </ul>
          <?php
          echo $after_widget;

  }


  public function update( $new_instance, $old_instance ) {
    $instance = $old_instance;
    $instance['title']    = strip_tags($new_instance['title']);
    $instance['category']    = strip_tags($new_instance['category']);
    return $instance;

  }

  public function form( $instance ) {
    $instance       = wp_parse_args( (array) $instance, array( 'title' => '' ) );
    $title        = strip_tags($instance['title']);
    $category        = strip_tags($instance['category']);
?>
    <p><label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Name:', 'odin'); ?></label>
    <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo esc_attr($title); ?>" /></p>

    <p><label for="<?php echo $this->get_field_id('category'); ?>"><?php _e('Category:', 'odin'); ?></label>
    <input class="widefat" id="<?php echo $this->get_field_id('category'); ?>" name="<?php echo $this->get_field_name('category'); ?>" type="text" value="<?php echo esc_attr($category); ?>" /></p>
<?php
  }
}

add_action('widgets_init', create_function('', 'return register_widget("Odin_category_widget");'));
