<?php
/**
 * The default template for displaying content.
 *
 * Used for both single and index/archive/author/catagory/search/tag.
 *
 * @package Odin
 * @since 2.2.0
 */
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(' entry-post clearfix '); ?>>
        <header class="entry-header">
          <?php
            if ( is_single() ) :
              the_title( '<h3 class="text-left entry-title">', '</h3>' );
            else :
              the_title( '<h3 class="text-left entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h3>' );
            endif;
          ?>
          <?php if ( 'post' == get_post_type() ) : ?>
            <div class="entry-meta">
              <hr style="border-color: #ddd;" />
              <?php odin_posted_on(); ?>
              <?php if ( in_array( 'category', get_object_taxonomies( get_post_type() ) ) ) : ?>
                <span class="cat-links"><?php echo __( 'Posted in:', 'odin' ) . ' ' . get_the_category_list( _x( ', ', 'Used between list items, there is a space after the comma.', 'odin' ) ); ?></span>
              <?php endif; ?>
              <?php the_tags( '<span class="tag-links">' . __( 'Tagged as:', 'odin' ) . ' ', ', ', '</span>' ); ?>
              <?php if ( ! post_password_required() && ( comments_open() || get_comments_number() ) ) : ?>
                | <span class="comments-link"><?php comments_popup_link( __( 'Leave a comment', 'odin' ), __( '1 Comment', 'odin' ), __( '% Comments', 'odin' ) ); ?></span>
              <?php endif; ?>
              <hr style="border-color: #ddd;" />
            </div><!-- .entry-meta -->
          <?php endif; ?>
        </header>
        <?php if( has_post_thumbnail() ): ?>
          <div class="col-xs-12 col-sm-12 col-md-3 col-lg-3">
            <a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>">
              <?php the_post_thumbnail(' img-thumbnail'); ?>
            </a>
          </div>
        <?php endif; ?>
        <div class="col-xs-12 col-sm-12 <?php if ( has_post_thumbnail() ) : echo "col-md-9"; else: echo "col-md-12"; endif; ?>">
            <?php the_excerpt(); ?>
            <a href="<?php the_permalink(); ?>" class="btn btn-default">Continue lendo...</a>
        </div>
</article><!-- #post-## -->
