<?php

    add_filter( 'rwmb_meta_boxes', 'your_prefix_meta_boxes' );
    function your_prefix_meta_boxes( $meta_boxes ) {
             
		// 	DOCUMENTOS GERAL
        $meta_boxes[] = array(
            'title'      => __( 'Documentos', 'textdomain' ),
            'post_types' => 'autografo,decreto-legislativo,indicacao,licitacao,proj_decre_leg,projeto_lei,projeto_resolucao,proposta_emenda,requerimento,resolucao,lei-municipal,codigo-etica,mocao',
            'fields'     => array(
            
			// FILE ADVANCED (WP 3.5+)
			array(
				'name'             => esc_html__( 'Arquivos'),
				'id'               => "documento_geral",
				'type'             => 'file_advanced',
				'max_file_uploads' => 100,
				'mime_type'        => 'application,audio,video', // Leave blank for all file types
			),	
			
            ),
        );	

		// 	BANNER
        $meta_boxes[] = array(
            'title'      => __( 'Informações adicionais', 'textdomain' ),
            'post_types' => 'slide',
            'fields'     => array(
            
            array(
                'id'   => 'linkbanner',
                'name' => __( 'Link do Banner', 'textdomain' ),
                'type' => 'text',
            ),	
			
            ),
        );	
		
		// 	VEREADORES
        $meta_boxes[] = array(
            'title'      => __( 'Informações adicionais', 'textdomain' ),
            'post_types' => 'vereadores_site',
            'fields'     => array(
            
            array(
                'id'   => 'funcao_ver',
                'name' => __( 'Função', 'textdomain' ),
                'type' => 'text',
            ),	
			
				
			
            ),
        );			
		
		// 	CONTAS PÚBLICAS
        $meta_boxes[] = array(
            'title'      => __( 'Informações adicionais', 'textdomain' ),
            'post_types' => 'contas_pdf',
            'fields'     => array(
            
			// DATE PUBLICACAO
			array(
				'name'       => esc_html__( 'Data', 'your-prefix' ),
				'id'         => "{$prefix}date_contas_publicas",
				'type'       => 'date',
				// jQuery date picker options. See here http://api.jqueryui.com/datepicker
				'js_options' => array(
					'appendText'      => esc_html__( '(dia-mês-ano)', 'your-prefix' ),
					'dateFormat'      => esc_html__( 'dd-mm-yy', 'your-prefix' ),
					'changeMonth'     => true,
					'changeYear'      => true,
					'showButtonPanel' => true,
				),
			),	

			// FILE ADVANCED (WP 3.5+)
			array(
				'name'             => esc_html__( 'Arquivos', 'your-prefix' ),
				'id'               => "{$prefix}file_advanced_contas",
				'type'             => 'file_advanced',
				'max_file_uploads' => 20,
				'mime_type'        => 'application,audio,video', // Leave blank for all file types
			),			
			
            ),
        );			

		// 	LICITAÇÕES
        $meta_boxes[] = array(
            'title'      => __( 'Informações adicionais', 'textdomain' ),
            'post_types' => 'licitacoes_site',
            'fields'     => array(
            
			// TEXTAREA
			array(
				'name' => esc_html__( 'Objeto', 'your-prefix' ),
				'id'   => "{$prefix}textarea_licitacao",
				'type' => 'textarea',
				'cols' => 20,
				'rows' => 3,
			),				
			
			// DATE PUBLICACAO
			array(
				'name'       => esc_html__( 'Publicação', 'your-prefix' ),
				'id'         => "{$prefix}date_licitacao_publi",
				'type'       => 'date',
				// jQuery date picker options. See here http://api.jqueryui.com/datepicker
				'js_options' => array(
					'appendText'      => esc_html__( '(dia-mês-ano)', 'your-prefix' ),
					'dateFormat'      => esc_html__( 'dd-mm-yy', 'your-prefix' ),
					'changeMonth'     => true,
					'changeYear'      => true,
					'showButtonPanel' => true,
				),
			),	

			// DATE ABERTURA
			array(
				'name'       => esc_html__( 'Abertura', 'your-prefix' ),
				'id'         => "{$prefix}date_licitacao_abertura",
				'type'       => 'date',
				// jQuery date picker options. See here http://api.jqueryui.com/datepicker
				'js_options' => array(
					'appendText'      => esc_html__( '(dia-mês-ano)', 'your-prefix' ),
					'dateFormat'      => esc_html__( 'dd-mm-yy', 'your-prefix' ),
					'changeMonth'     => true,
					'changeYear'      => true,
					'showButtonPanel' => true,
				),
			),				
			
            ),
        );	
		
		// 	Legislação
        $meta_boxes[] = array(
            'title'      => __( 'Informações adicionais', 'textdomain' ),
            'post_types' => 'legislacao_site',
            'fields'     => array(
            
			// DATE
			array(
				'name'       => esc_html__( 'Data', 'your-prefix' ),
				'id'         => "{$prefix}date_legi",
				'type'       => 'date',
				// jQuery date picker options. See here http://api.jqueryui.com/datepicker
				'js_options' => array(
					'appendText'      => esc_html__( '(dia-mês-ano)', 'your-prefix' ),
					'dateFormat'      => esc_html__( 'dd-mm-yy', 'your-prefix' ),
					'changeMonth'     => true,
					'changeYear'      => true,
					'showButtonPanel' => true,
				),
			),			
			
			// TEXTAREA
			array(
				'name' => esc_html__( 'Descrição', 'your-prefix' ),
				'id'   => "{$prefix}textarea_legi",
				'type' => 'textarea',
				'cols' => 20,
				'rows' => 3,
			),	

			// TEXTAREA
			array(
				'name' => esc_html__( 'Informações Adicionais', 'your-prefix' ),
				'id'   => "{$prefix}info_adc_legi",
				'type' => 'textarea',
				'cols' => 20,
				'rows' => 3,
			),				
			
			// FILE ADVANCED (WP 3.5+)
			array(
				'name'             => esc_html__( 'Arquivos', 'your-prefix' ),
				'id'               => "{$prefix}file_advanced_legi",
				'type'             => 'file_advanced',
				'max_file_uploads' => 10,
				'mime_type'        => 'application,audio,video', // Leave blank for all file types
			),		
			
            ),
        );	

		// 	PROPOSITURAS
        $meta_boxes[] = array(
            'title'      => __( 'Informações adicionais', 'textdomain' ),
            'post_types' => 'proposituras_site',
            'fields'     => array(
            
			// DATE
			array(
				'name'       => esc_html__( 'Data', 'your-prefix' ),
				'id'         => "{$prefix}date_proposit",
				'type'       => 'date',
				// jQuery date picker options. See here http://api.jqueryui.com/datepicker
				'js_options' => array(
					'appendText'      => esc_html__( '(dia-mês-ano)', 'your-prefix' ),
					'dateFormat'      => esc_html__( 'dd-mm-yy', 'your-prefix' ),
					'changeMonth'     => true,
					'changeYear'      => true,
					'showButtonPanel' => true,
				),
			),			
			
			// TEXTAREA
			array(
				'name' => esc_html__( 'Descrição', 'your-prefix' ),
				'id'   => "{$prefix}textarea_proposit",
				'type' => 'textarea',
				'cols' => 20,
				'rows' => 3,
			),		

			// TEXTAREA
			array(
				'name' => esc_html__( 'Informações Adicionais', 'your-prefix' ),
				'id'   => "{$prefix}info_adc_proposit",
				'type' => 'textarea',
				'cols' => 20,
				'rows' => 3,
			),				
			
			// FILE ADVANCED (WP 3.5+)
			array(
				'name'             => esc_html__( 'Arquivos', 'your-prefix' ),
				'id'               => "{$prefix}file_advanced_proposit",
				'type'             => 'file_advanced',
				'max_file_uploads' => 10,
				'mime_type'        => 'application,audio,video', // Leave blank for all file types
			),		
			
            ),
        );

		// 	SUB-DOCUMENTOS
        $meta_boxes[] = array(
            'title'      => __( 'Informações adicionais', 'textdomain' ),
            'post_types' => 'sub_documentos_pdf',
            'fields'     => array(
            
			// DATE
			array(
				'name'       => esc_html__( 'Data', 'your-prefix' ),
				'id'         => "{$prefix}date_sub_documentos",
				'type'       => 'date',
				// jQuery date picker options. See here http://api.jqueryui.com/datepicker
				'js_options' => array(
					'appendText'      => esc_html__( '(dia-mês-ano)', 'your-prefix' ),
					'dateFormat'      => esc_html__( 'dd-mm-yy', 'your-prefix' ),
					'changeMonth'     => true,
					'changeYear'      => true,
					'showButtonPanel' => true,
				),
			),			
			
			// TEXTAREA
			array(
				'name' => esc_html__( 'Descrição', 'your-prefix' ),
				'id'   => "{$prefix}textarea_sub_documentos",
				'type' => 'textarea',
				'cols' => 20,
				'rows' => 3,
			),				
			
			// FILE ADVANCED (WP 3.5+)
			array(
				'name'             => esc_html__( 'Arquivos', 'your-prefix' ),
				'id'               => "{$prefix}file_advanced_sub_documentos",
				'type'             => 'file_advanced',
				'max_file_uploads' => 10,
				'mime_type'        => 'application,audio,video', // Leave blank for all file types
			),		
			
            ),
        );			
		
        return $meta_boxes;
    }

?>