<?php 

/*
Template Name: Licitações
*/
 
// Buscar arquivo header.php
get_header(); ?> 

<div class="title-page">
<div class="container-fluid">
	<div class="row">
		<div class="col-md-12">
			<h1><?php the_title(); ?></h1>		
		</div> 
	</div>
</div>
</div>

<section class="container-fluid">
	<div class="row">
	<div class="col-md-3 sidebar-esic hidden">
		<h3 class="text-uppercase">Pesquisa com Filtro</h3>
		<?php echo do_shortcode( '[ULWPQSF id=752]' ); ?>
		<h3 class="text-uppercase">Opções para exportação</h3>
		<br>
		<ol class="list-inline">
			<li><a href="" class="btn btn-info btn-sm">CSV</a></li>
			<li><a href="" class="btn btn-info btn-sm">XLS</a></li>
			<li><a href="" class="btn btn-info btn-sm">XLSX</a></li>
			<li><a href="" class="hidden btn btn-info btn-sm">XLM</a></li>
		</ol>
	</div> 	
		<div class="col-md-12 page-pdf">
		 <table class="table">
		  <tr class="bg-primary text-uppercase">
		    <td>Processo</td>
		    <td>Objeto</td>
		    <td>Publicação</td>
		    <td>Abertura</td>
		    <td>Modalidade</td>
			<td>Situação</td>
			<td class="text-right">Arquivo</td>
		  </tr>
		
			  <?php 
			    query_posts(array( 	       

					'post_type'	=> 'licitacao',
					'meta_key'	=> 'publicacao',
					'orderby'	=> 'meta_value_num',
					'order'		=> 'DESC',
					'posts_per_page' => -1

			    ) );  
			  ?>
			  <?php while (have_posts()) : the_post(); ?>	 		
			  <tr>
			    <td><?php the_field('processo-licitacao'); ?></td>
				<td><?php the_field('objeto'); ?></td>
				<td>
				
				<?php 

				// get raw date
				$date = get_field('publicacao', false, false); 


				// make date object
				$date = new DateTime($date);

				?>				
				
				<?php echo $date->format('d-m-Y'); ?>
				
				</td> 
			    <td><?php the_field('abertura'); ?></td>
			    <td>
				<?php
					$term_list = wp_get_post_terms($post->ID, 'modalidade_lic', array("fields" => "names"));
					print_r($term_list[0]);
				?>				
				</td>
			    <td>
				<?php
					$term_list = wp_get_post_terms($post->ID, 'situacao_lic', array("fields" => "names"));
					print_r($term_list[0]);
				?>				
				</td>
			    <td class="text-right"><a href="<?php the_permalink(); ?>" class="btn btn-success text-uppercase btn-xs">Mais detalhes</a></td>  				
			  </tr>
		 	<?php endwhile;?>		  
		</table>		
		
		</div>
	</div>
</section>

<?php 
// buscar arquivo footer.php
get_footer(); ?>