<?php

function fun_licitacao() {

	$labels = array(
		'name'                  => _x( 'Licitações', 'Post Type General Name', 'text_domain' ),
		'singular_name'         => _x( 'Licitações', 'Post Type Singular Name', 'text_domain' ),
		'menu_name'             => __( 'Licitações', 'text_domain' ),
		'name_admin_bar'        => __( 'Licitações', 'text_domain' ),
		'archives'              => __( 'Item Archives', 'text_domain' ),
		'attributes'            => __( 'Item Attributes', 'text_domain' ),
		'parent_item_colon'     => __( 'Parent Item:', 'text_domain' ),
		'all_items'             => __( 'Todos as Licitações', 'text_domain' ),
		'add_new_item'          => __( 'Adicionar nova', 'text_domain' ),
		'add_new'               => __( 'Adicionar nova', 'text_domain' ),
		'new_item'              => __( 'Novo Convênio', 'text_domain' ),
		'edit_item'             => __( 'Editar Licitação', 'text_domain' ),
		'update_item'           => __( 'Atualizar Licitação', 'text_domain' ),
		'view_item'             => __( 'Ver Publicação', 'text_domain' ),
		'view_items'            => __( 'View Items', 'text_domain' ),
		'search_items'          => __( 'Search Item', 'text_domain' ),
		'not_found'             => __( 'Not found', 'text_domain' ),
		'not_found_in_trash'    => __( 'Not found in Trash', 'text_domain' ),
		'featured_image'        => __( 'Featured Image', 'text_domain' ),
		'set_featured_image'    => __( 'Set featured image', 'text_domain' ),
		'remove_featured_image' => __( 'Remove featured image', 'text_domain' ),
		'use_featured_image'    => __( 'Use as featured image', 'text_domain' ),
		'insert_into_item'      => __( 'Insert into item', 'text_domain' ),
		'uploaded_to_this_item' => __( 'Uploaded to this item', 'text_domain' ),
		'items_list'            => __( 'Items list', 'text_domain' ),
		'items_list_navigation' => __( 'Items list navigation', 'text_domain' ),
		'filter_items_list'     => __( 'Filter items list', 'text_domain' ),
	);
	$args = array(
		'label'                 => __( 'Post Type', 'text_domain' ),
		'description'           => __( 'Post Type Description', 'text_domain' ),
		'labels'                => $labels,
		'supports'              => array( 'title', ),
		'hierarchical'          => false,
		'public'                => true,
		'show_ui'               => true,
		'show_in_menu'          => true,
		'menu_position'         => 5,
		'show_in_admin_bar'     => true,
		'show_in_nav_menus'     => true,
		'can_export'            => true,
		'has_archive'           => true,		
		'exclude_from_search'   => false,
		'publicly_queryable'    => true, 
		'rewrite'               => false,
		'capability_type'       => 'post',
	);
	register_post_type( 'licitacao', $args );

}
add_action( 'init', 'fun_licitacao', 0 );

// Modalidade
function cwp_register_taxonomy_genero_modalidade(){
     register_taxonomy(
          'modalidade_lic',
          'licitacao',
          array(
               'label' => __('Modalidade da Licitação'),
               'rewrite' => array('slug' => 'modalidade-licitacao'),
               'hierarchical' => true,
			   'show_admin_column' => true,
          )
     );
}
add_action('init', 'cwp_register_taxonomy_genero_modalidade');

// Situação
function cwp_register_taxonomy_genero_situacao_licitacao(){
     register_taxonomy(
          'situacao_lic',
          'licitacao',
          array(
               'label' => __('Situação da Licitação'),
               'rewrite' => array('slug' => 'situacao-licitacao'),
               'hierarchical' => true,
			   'show_admin_column' => true,
          )
     );
}
add_action('init', 'cwp_register_taxonomy_genero_situacao_licitacao');

// Relacionar
function relacionar_licitatacao(){
     register_taxonomy(
          'rel-licitacoes',
          'licitacao',
          array(
               'label' => __('Relacionar'),
               'rewrite' => array('slug' => 'rel-licitacao'),
               'hierarchical' => true,
			   'show_admin_column' => true,
          )
     );
}
add_action('init', 'relacionar_licitatacao');

?>