<?php

// Register Custom Post Type
function fun_decreto_legis() {

	$labels = array(
		'name'                  => _x( 'Decretos Legislativos', 'Post Type General Name', 'text_domain' ),
		'singular_name'         => _x( 'Decreto Legislativo', 'Post Type Singular Name', 'text_domain' ),
		'menu_name'             => __( 'Decretos Legislativos', 'text_domain' ),
		'name_admin_bar'        => __( 'Decretos Legislativos', 'text_domain' ),
		'archives'              => __( 'Item Archives', 'text_domain' ),
		'attributes'            => __( 'Item Attributes', 'text_domain' ),
		'parent_item_colon'     => __( 'Parent Item:', 'text_domain' ),
		'all_items'             => __( 'Todos os Decretos Legislativos', 'text_domain' ),
		'add_new_item'          => __( 'Adicionar Novo', 'text_domain' ),
		'add_new'               => __( 'Adicionar Novo', 'text_domain' ),
		'new_item'              => __( 'Adicionar Novo', 'text_domain' ),
		'edit_item'             => __( 'Editar Item', 'text_domain' ),
		'update_item'           => __( 'Atualizar Item', 'text_domain' ),
		'view_item'             => __( 'Ver Item', 'text_domain' ),
		'view_items'            => __( 'Ver Item', 'text_domain' ),
		'search_items'          => __( 'Procurar Itens', 'text_domain' ),
		'not_found'             => __( 'Sem informações', 'text_domain' ),
		'not_found_in_trash'    => __( 'Não encontrado na Lixeira', 'text_domain' ),
		'featured_image'        => __( 'Featured Image', 'text_domain' ),
		'set_featured_image'    => __( 'Set featured image', 'text_domain' ),
		'remove_featured_image' => __( 'Remove featured image', 'text_domain' ),
		'use_featured_image'    => __( 'Use as featured image', 'text_domain' ),
		'insert_into_item'      => __( 'Insert into item', 'text_domain' ),
		'uploaded_to_this_item' => __( 'Uploaded to this item', 'text_domain' ),
		'items_list'            => __( 'Items list', 'text_domain' ),
		'items_list_navigation' => __( 'Items list navigation', 'text_domain' ),
		'filter_items_list'     => __( 'Filter items list', 'text_domain' ),
	);
	$args = array(
		'label'                 => __( 'Publicação', 'text_domain' ),
		'description'           => __( 'Seção para publicação de arquivos', 'text_domain' ),
		'labels'                => $labels,
		'supports'              => array( 'title' ),
		'hierarchical'          => false,
		'public'                => true,
		'show_ui'               => true,
		'show_in_menu'          => true,
		'menu_position'         => 5,
		'show_in_admin_bar'     => true,
		'show_in_nav_menus'     => true,
		'can_export'            => true,
		'has_archive'           => true,
		'exclude_from_search'   => false,
		'publicly_queryable'    => true,
		'capability_type'       => 'post',
	);
	register_post_type( 'decreto-legislativo', $args );

}
add_action( 'init', 'fun_decreto_legis', 0 );

// EXERCICIO
function exercicio_decretos_legis(){
     register_taxonomy( 
          'exercicio_decreto_legislativo',
          'decreto-legislativo',
          array(
               'label' => __('Exercício'),
               'rewrite' => array('slug' => 'exercicio-decreto-legislativo'),
               'hierarchical' => true,
			   'show_admin_column' => true,
          )
     );
}
add_action('init', 'exercicio_decretos_legis');

// RELACIONAR
function noticia_decretos_legis(){
     register_taxonomy( 
          'noticia_decreto_legislativo',
          'decreto-legislativo',
          array(
               'label' => __('Relacionar'),
               'rewrite' => array('slug' => 'noticia-covid-decreto-legislativo'),
               'hierarchical' => true,
			   'show_admin_column' => true,
          )
     );
}
add_action('init', 'noticia_decretos_legis');

?>